/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.prefs;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.Workspace;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.embedded.EmbeddedHub;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.util.Password;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ConnectivityPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static Logger log = LogManager.getLogger(ConnectivityPrefPage.class);
    public static final String LFS_USER = "lfs_user";
    public static final String LFS_PWD = "lfs_pwd";
    public static final String LFS_WORKSPACE_NAME = "lfs_workspace_name";
    public static final String LFS_HOST_NAME = "lfs_host_name";
    public static final String LFS_HOST_NAMES = "lfs_host_names";
    public static final String LFS_PORT_NUM = "lfs_port_num";
    public static final String TCP_PORT_NUM = "tcp_port_num";
    public static final String TCP_ENABLED = "tcp_enabled";
    public static final String UDP_PORT_NUM = "udp_port_num";
    public static final String UDP_ENABLED = "udp_enabled";
    public static final String TCP_SYS_PORT_NUM = "tcp_sys_port_num";
    public static final String TCP_SYS_ENABLED = "tcp_sys_enabled";
    public static final String TCP_RX_FORMAT = "tcp_rx_format";
    public static final String UDP_SYS_PORT_NUM = "udp_sys_port_num";
    public static final String UDP_SYS_ENABLED = "udp_sys_enabled";
    public static final String SERVER_MODE = "server_mode";
    public static final String LFS_AUTO_CONN = "lfs_auto_connect";
    public static final String LFS_AUTO_LOGIN = "lfs_auto_login";
    public static final String LFS_SUPPORT_URL = "lfs_support_url";
    public static final String LFS_UPDATES_URL = "lfs_updates_url";
    public static final String LFS_FIRST_TIME = "lfs_first_time";
    public static final String LFS_SSL = "lfs_ssl";
    public static final String LFS_READ_TIMEOUT = "lfs_read_timeout";
    public static final String DEFAULT_LFS_HOST_NAME = "localhost";
    public static final String DEFAULT_LFS_WORKSPACE_NAME = "My workspace";
    public static final String DEFAULT_SUPPORT_URL = "https://moonlits.atlassian.net/servicedesk/customer/portals";
    public static final String DEFAULT_UPDATES_URL = "https://www.moonlit-software.com/logfaces/updates";
    public static final int DEFAULT_LFS_PORT_NUM = 8050;
    public static final int DEFAULT_TCP_PORT_NUM = 55200;
    public static final int DEFAULT_UDP_PORT_NUM = 55201;
    public static final int DEFAULT_TCP_SYS_PORT_NUM = 1468;
    public static final int DEFAULT_UDP_SYS_PORT_NUM = 514;
    public static final int DEFAULT_READ_TIMEOUT = 60;
    private boolean isWindows;
    private boolean isDirty;
    private ConnectivityChangeListener listener = new ConnectivityChangeListener();
    private Workspace workspace = WorkspaceHolder.getInstance().getCurrentWorkspace();
    private ScopedPreferenceStore preferences;
    private BooleanFieldEditor autoConnect;
    private BooleanFieldEditor sslEditor;
    private StringFieldEditor serverHostEditor;
    private StringFieldEditor userEditor;
    private StringFieldEditor passwordEditor;
    private StringFieldEditor supportUrl;
    private StringFieldEditor updateUrl;
    private IntegerFieldEditor serverPortEditor;
    private IntegerFieldEditor timeoutEditor;
    private BooleanFieldEditor tcpPortEnabled;
    private BooleanFieldEditor udpPortEnabled;
    private BooleanFieldEditor tcpSysPortEnabled;
    private BooleanFieldEditor udpSysPortEnabled;
    private IntegerFieldEditor tcpPortEditor;
    private IntegerFieldEditor udpPortEditor;
    private IntegerFieldEditor tcpSysPortEditor;
    private IntegerFieldEditor udpSysPortEditor;
    private RadioGroupFieldEditor tcpFormat;

    public ConnectivityPrefPage() {
        super(1);
        String osname = System.getProperty("os.name");
        if (osname != null) {
            this.isWindows = osname.indexOf("Windows") != -1;
        }
        this.preferences = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "com.moonlit.logfaces.client.plugin");
        this.preferences.setDefault(LFS_AUTO_CONN, false);
        this.preferences.setDefault(LFS_WORKSPACE_NAME, DEFAULT_LFS_WORKSPACE_NAME);
        this.preferences.setDefault(LFS_HOST_NAME, DEFAULT_LFS_HOST_NAME);
        this.preferences.setDefault(LFS_PORT_NUM, 8050);
        this.preferences.setDefault(LFS_PORT_NUM, 8050);
        this.preferences.setDefault(LFS_READ_TIMEOUT, 60);
        this.preferences.setDefault(LFS_SUPPORT_URL, DEFAULT_SUPPORT_URL);
        this.preferences.setDefault(LFS_UPDATES_URL, DEFAULT_UPDATES_URL);
        this.preferences.setDefault(SERVER_MODE, false);
        this.preferences.setDefault(TCP_ENABLED, false);
        this.preferences.setDefault(UDP_ENABLED, false);
        this.preferences.setDefault(TCP_PORT_NUM, 55200);
        this.preferences.setDefault(UDP_PORT_NUM, 55201);
        this.setPreferenceStore((IPreferenceStore)this.preferences);
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/connection.gif"));
    }

    protected void createFieldEditors() {
        this.autoConnect = new BooleanFieldEditor(LFS_AUTO_CONN, "Use these settings automatically on startup", this.getFieldEditorParent());
        this.addField((FieldEditor)this.autoConnect);
        Label label = new Label(this.getFieldEditorParent(), 256);
        label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 4));
        if (!this.preferences.getBoolean(SERVER_MODE)) {
            this.serverHostEditor = new StringFieldEditor(LFS_HOST_NAME, "LFS server host  :", this.getFieldEditorParent());
            this.addField((FieldEditor)this.serverHostEditor);
            this.serverPortEditor = new IntegerFieldEditor(LFS_PORT_NUM, "LFS server port : ", this.getFieldEditorParent());
            this.serverPortEditor.setValidRange(1, 65534);
            this.addField((FieldEditor)this.serverPortEditor);
            this.timeoutEditor = new IntegerFieldEditor(LFS_READ_TIMEOUT, "Read timeout (sec) : ", this.getFieldEditorParent());
            this.timeoutEditor.setValidRange(-1, 65534);
            this.addField((FieldEditor)this.timeoutEditor);
            label = new Label(this.getFieldEditorParent(), 256);
            label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 4));
            this.sslEditor = new BooleanFieldEditor(LFS_SSL, "Use secure connection (SSL)", this.getFieldEditorParent());
            this.addField((FieldEditor)this.sslEditor);
            if (this.workspace.isLoginRequired()) {
                this.userEditor = new StringFieldEditor(LFS_USER, "Login user name (if required)  :", this.getFieldEditorParent());
                this.passwordEditor = new StringFieldEditor(LFS_PWD, "Login password (if required)  :", this.getFieldEditorParent());
                this.passwordEditor.getTextControl(this.getFieldEditorParent()).setEchoChar('*');
                this.addField((FieldEditor)this.userEditor);
                this.addField((FieldEditor)this.passwordEditor);
            }
            label = new Label(this.getFieldEditorParent(), 256);
            label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 4));
            if (this.isWindows) {
                this.supportUrl = new StringFieldEditor(LFS_SUPPORT_URL, "logFaces support:", this.getFieldEditorParent());
                this.addField((FieldEditor)this.supportUrl);
            }
            this.updateUrl = new StringFieldEditor(LFS_UPDATES_URL, "Update site:", this.getFieldEditorParent());
            this.addField((FieldEditor)this.updateUrl);
        } else {
            this.tcpPortEnabled = new BooleanFieldEditor(TCP_ENABLED, "log4x TCP server", this.getFieldEditorParent());
            this.tcpPortEditor = new IntegerFieldEditor(TCP_PORT_NUM, "port number: ", this.getFieldEditorParent());
            this.tcpPortEditor.setValidRange(1, 65534);
            this.tcpFormat = new RadioGroupFieldEditor(TCP_RX_FORMAT, "", 2, (String[][])new String[][]{{"log4j xml format", "xml"}, {"logFaces json format", "json"}}, this.getFieldEditorParent(), true);
            this.addField((FieldEditor)this.tcpPortEnabled);
            this.addField((FieldEditor)this.tcpPortEditor);
            this.addField((FieldEditor)this.tcpFormat);
            label = new Label(this.getFieldEditorParent(), 256);
            label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 4));
            this.udpPortEnabled = new BooleanFieldEditor(UDP_ENABLED, "log4x UDP server", this.getFieldEditorParent());
            this.udpPortEditor = new IntegerFieldEditor(UDP_PORT_NUM, "port number: ", this.getFieldEditorParent());
            this.udpPortEditor.setValidRange(1, 65534);
            this.addField((FieldEditor)this.udpPortEnabled);
            this.addField((FieldEditor)this.udpPortEditor);
            label = new Label(this.getFieldEditorParent(), 256);
            label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 4));
            this.tcpSysPortEnabled = new BooleanFieldEditor(TCP_SYS_ENABLED, "syslog TCP server", this.getFieldEditorParent());
            this.tcpSysPortEditor = new IntegerFieldEditor(TCP_SYS_PORT_NUM, "port number: ", this.getFieldEditorParent());
            this.tcpSysPortEditor.setValidRange(1, 65534);
            this.addField((FieldEditor)this.tcpSysPortEnabled);
            this.addField((FieldEditor)this.tcpSysPortEditor);
            label = new Label(this.getFieldEditorParent(), 256);
            label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 4));
            this.udpSysPortEnabled = new BooleanFieldEditor(UDP_SYS_ENABLED, "syslog UDP server", this.getFieldEditorParent());
            this.udpSysPortEditor = new IntegerFieldEditor(UDP_SYS_PORT_NUM, "port number: ", this.getFieldEditorParent());
            this.udpSysPortEditor.setValidRange(1, 65534);
            this.addField((FieldEditor)this.udpSysPortEnabled);
            this.addField((FieldEditor)this.udpSysPortEditor);
            label = new Label(this.getFieldEditorParent(), 256);
            label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 4));
            if (this.isWindows) {
                this.supportUrl = new StringFieldEditor(LFS_SUPPORT_URL, "LFS support url:", this.getFieldEditorParent());
                this.addField((FieldEditor)this.supportUrl);
            }
            this.updateUrl = new StringFieldEditor(LFS_UPDATES_URL, "Update site:", this.getFieldEditorParent());
            this.addField((FieldEditor)this.updateUrl);
        }
    }

    protected void initialize() {
        super.initialize();
        if (this.timeoutEditor != null) {
            this.timeoutEditor.setPropertyChangeListener((IPropertyChangeListener)this.listener);
        }
        if (!this.preferences.getBoolean(SERVER_MODE)) {
            this.serverHostEditor.setPropertyChangeListener((IPropertyChangeListener)this.listener);
            this.serverPortEditor.setPropertyChangeListener((IPropertyChangeListener)this.listener);
            this.sslEditor.setPropertyChangeListener((IPropertyChangeListener)this.listener);
            if (this.workspace.isLoginRequired()) {
                this.userEditor.setPropertyChangeListener((IPropertyChangeListener)this.listener);
                this.passwordEditor.setPropertyChangeListener((IPropertyChangeListener)this.listener);
            }
        } else {
            this.tcpPortEnabled.setPropertyChangeListener((IPropertyChangeListener)this.listener);
            this.tcpPortEditor.setPropertyChangeListener((IPropertyChangeListener)this.listener);
            this.tcpFormat.setPropertyChangeListener((IPropertyChangeListener)this.listener);
            this.udpPortEnabled.setPropertyChangeListener((IPropertyChangeListener)this.listener);
            this.udpPortEditor.setPropertyChangeListener((IPropertyChangeListener)this.listener);
            this.tcpSysPortEnabled.setPropertyChangeListener((IPropertyChangeListener)this.listener);
            this.tcpSysPortEditor.setPropertyChangeListener((IPropertyChangeListener)this.listener);
            this.udpSysPortEnabled.setPropertyChangeListener((IPropertyChangeListener)this.listener);
            this.udpSysPortEditor.setPropertyChangeListener((IPropertyChangeListener)this.listener);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (this.passwordEditor != null) {
            String pwd = this.passwordEditor.getTextControl(this.getFieldEditorParent()).getText();
            if (!Password.isObfuscated((String)pwd)) {
                pwd = Password.obfuscate((String)pwd);
            }
            this.passwordEditor.getTextControl(this.getFieldEditorParent()).setText(pwd);
        }
        super.performOk();
        try {
            this.preferences.save();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (this.isDirty) {
            this.workspace.reconnect(false);
            if (this.preferences.getBoolean(SERVER_MODE)) {
                try {
                    EmbeddedHub.getInstance().restart();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    Utils.displayPopup("Failed to setup servers hub", e.getMessage(), true);
                    return false;
                }
            }
        }
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    class ConnectivityChangeListener
    implements IPropertyChangeListener {
        ConnectivityChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            ConnectivityPrefPage.this.isDirty = true;
        }
    }
}

