/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.options;

import com.moonlit.logfaces.client.options.Option;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;

public class ScalarOption
implements Option {
    private String name = "";
    private String title = "";
    private String value = "";
    private Text input;

    public ScalarOption() {
    }

    public ScalarOption(String name, Object value) {
        this.name = name;
        this.title = "";
        this.value = value.toString();
    }

    public ScalarOption(String name, String title, String value) {
        this.name = name;
        this.title = title;
        this.value = value;
    }

    @Override
    public void load(IMemento memento) {
        this.name = memento.getString("name");
        this.title = memento.getString("title");
        this.value = memento.getString("value");
    }

    @Override
    public void save(IMemento parent) {
        IMemento m = parent.createChild("option");
        m.putString("class", this.getClass().getName());
        m.putString("name", this.name);
        m.putString("title", this.title);
        m.putString("value", this.value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Composite renderComposite(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label label = new Label(content, 64);
        label.setText(this.title);
        GridData data = new GridData(1796);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.input = new Text(content, 2048);
        this.input.setLayoutData((Object)new GridData(768));
        this.input.setText(this.value);
        return content;
    }

    @Override
    public void save() {
        if (this.input == null) {
            return;
        }
        this.value = this.input.getText();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(int ivalue) {
        this.value = Integer.toString(ivalue);
    }

    public void setValue(double dvalue) {
        this.value = Double.toString(dvalue);
    }

    public int getInt(int def) {
        try {
            return Integer.parseInt(this.value);
        }
        catch (Exception e) {
            return def;
        }
    }

    public double getDouble(double def) {
        try {
            return Double.parseDouble(this.value);
        }
        catch (Exception e) {
            return def;
        }
    }
}

