/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.options;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.options.Option;
import com.moonlit.logfaces.client.utils.StringUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;

public class RangeColorOption
implements Option {
    private String title;
    private String name;
    private List<RangeColor> ranges;
    private static Logger log = LogManager.getLogger(RangeColorOption.class);

    public RangeColorOption() {
    }

    public RangeColorOption(String name, String title, int size) {
        this.name = name;
        this.title = title;
        this.ranges = Lists.newArrayList();
        int i = 0;
        while (i < size) {
            this.ranges.add(new RangeColor());
            ++i;
        }
    }

    @Override
    public void load(IMemento memento) {
        this.name = memento.getString("name");
        this.title = memento.getString("title");
        this.ranges = Lists.newArrayList();
        IMemento[] iMementoArray = memento.getChildren("range");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            Color color;
            IMemento m = iMementoArray[n2];
            RangeColor rc = new RangeColor();
            rc.threshold = m.getInteger("threshold");
            String[] split = StringUtils.tokenizeToStringArray(m.getString("color"), ",");
            rc.color = color = new Color(null, Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
            this.ranges.add(rc);
            ++n2;
        }
    }

    @Override
    public void save(IMemento parent) {
        IMemento m = parent.createChild("option");
        m.putString("class", this.getClass().getName());
        m.putString("name", this.name);
        m.putString("title", this.title);
        for (RangeColor rc : this.ranges) {
            IMemento rm = m.createChild("range");
            rm.putInteger("threshold", rc.threshold);
            rm.putString("color", String.format("%d,%d,%d", rc.color.getRed(), rc.color.getGreen(), rc.color.getBlue()));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Composite renderComposite(final Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label title = new Label(content, 64);
        title.setText(this.title);
        title.setLayoutData((Object)new GridData(1796));
        title.setFont(parent.getFont());
        for (RangeColor rc : this.ranges) {
            Composite composite = new Composite(content, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            composite.setLayout((Layout)layout);
            Label label = new Label(composite, 64);
            label.setText("Higher than:");
            label.setLayoutData((Object)new GridData(1, 4, false, false, 1, 1));
            label.setFont(parent.getFont());
            rc.input = new Text(composite, 2048);
            rc.input.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            rc.input.setText("" + rc.threshold);
            GridData gd = new GridData(3, 2, false, false, 1, 1);
            gd.widthHint = 24;
            gd.heightHint = 24;
            rc.colorPicker = new Label(composite, 0);
            rc.colorPicker.setToolTipText("click to change the foreground color");
            rc.colorPicker.setLayoutData((Object)gd);
            rc.colorPicker.setBackground(rc.color);
            final RangeColor frc = rc;
            rc.colorPicker.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    RangeColorOption.this.handleColor(parent, frc);
                }
            });
        }
        return content;
    }

    @Override
    public void save() {
        for (RangeColor rc : this.ranges) {
            try {
                rc.threshold = Integer.parseInt(rc.input.getText());
                rc.color = rc.colorPicker.getBackground();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void handleColor(Composite parent, RangeColor rc) {
        ColorDialog dlg = new ColorDialog(parent.getShell());
        dlg.setRGB(rc.color.getRGB());
        RGB rgb = dlg.open();
        if (rgb == null) {
            return;
        }
        rc.color = new Color(null, rgb);
        rc.colorPicker.setBackground(rc.color);
    }

    public Color getColor(int value) {
        Color color = EventStyles.FG_LFS;
        Collections.sort(this.ranges, new Comparator<RangeColor>(){

            @Override
            public int compare(RangeColor rc1, RangeColor rc2) {
                return rc1.threshold - rc2.threshold;
            }
        });
        for (RangeColor rc : this.ranges) {
            if (value <= rc.threshold) continue;
            color = rc.color;
        }
        return color;
    }

    class RangeColor {
        int threshold;
        Text input;
        Label colorPicker;
        Color color = EventStyles.FG_LFS;

        RangeColor() {
        }
    }
}

