/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.options;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.options.Option;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OptionsDialog
extends Dialog {
    private List<Option> options;
    private String title;

    public OptionsDialog(Shell parent, String title, List<Option> options) {
        super(parent);
        this.options = options;
        this.title = title;
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 25;
        gridLayout.verticalSpacing = 0;
        container.setLayout((Layout)gridLayout);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        for (Option option : this.options) {
            option.renderComposite(container);
        }
        this.getShell().setMinimumSize(400, 200);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        newShell.setImage(ImageHolder.getInstance().getImage("icons/query.gif"));
    }

    protected void okPressed() {
        for (Option option : this.options) {
            option.save();
        }
        super.okPressed();
    }
}

