/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.options;

import com.moonlit.logfaces.client.options.Option;
import com.moonlit.logfaces.client.utils.StringUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;

public class EnumOption<T extends Enum<T>>
implements Option {
    private Class<T> type;
    private String name = "";
    private String title = "";
    private T value;
    private Combo combo;

    public EnumOption() {
    }

    public EnumOption(String name, String title, T value) {
        this.name = name;
        this.title = title;
        this.value = value;
        this.type = value.getClass();
    }

    @Override
    public void load(IMemento memento) {
        this.name = memento.getString("name");
        this.title = memento.getString("title");
        try {
            this.type = Class.forName(memento.getString("type"));
            this.value = Enum.valueOf(this.type, memento.getString("value"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void save(IMemento parent) {
        IMemento m = parent.createChild("option");
        m.putString("name", this.name);
        m.putString("title", this.title);
        m.putString("class", this.getClass().getName());
        if (this.value != null) {
            m.putString("value", ((Enum)this.value).name());
        }
        if (this.type != null) {
            m.putString("type", this.type.getName());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Composite renderComposite(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        if (StringUtils.hasText(this.title)) {
            Label label = new Label(content, 64);
            label.setText(this.title);
            GridData data = new GridData(1796);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.combo = new Combo(content, 8);
        this.combo.setLayoutData((Object)new GridData(768));
        Enum[] enumArray = this.getValues();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum entry = enumArray[n2];
            this.combo.add(entry.toString());
            ++n2;
        }
        this.combo.setText(((Enum)this.value).toString());
        return content;
    }

    @Override
    public void save() {
        if (this.combo == null) {
            return;
        }
        int sel = this.combo.getSelectionIndex();
        Enum[] values = this.getValues();
        if (sel > 0 && sel < values.length) {
            this.value = values[sel];
        }
    }

    public T getValue() {
        return this.value;
    }

    public T[] getValues() {
        return (Enum[])this.type.getEnumConstants();
    }

    public void setValue(T value) {
        this.value = value;
    }
}

