/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.net;

import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.HessianServiceException;
import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.LoginHandler;
import com.moonlit.logfaces.client.Workspace;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.embedded.LfsEmbeddedSession;
import com.moonlit.logfaces.client.jobs.FetchRepoJob;
import com.moonlit.logfaces.client.model.RepositoryModel;
import com.moonlit.logfaces.client.net.ConnectionProfile;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.client.utils.Compatibility;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.conf.MdcMap;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import com.moonlit.logfaces.server.util.LfsEventBus;
import com.moonlit.logfaces.server.vo.AlertVO;
import java.io.File;
import java.net.SocketException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class LfsConnector
implements IEclipsePreferences.IPreferenceChangeListener {
    private static Logger log = LogManager.getLogger(LfsConnector.class);
    private static LfsConnector instance;
    private HessianProxyFactory factory;
    private String sid;
    private LfsRemote connection;
    private Watchdog watchdog;
    private boolean loginRequired;
    private List<AlertVO> alerts = Lists.newArrayList();
    private long lastAlertTime;

    static {
        String storepath = String.format("%s%scacerts", Platform.getConfigurationLocation().getURL().getPath(), File.separator);
        if (new File(storepath).isFile()) {
            System.setProperty("javax.net.ssl.trustStore", storepath);
        }
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                return true;
            }
        });
    }

    private LfsConnector() {
        this.factory = new HessianProxyFactory();
        this.factory.setReadTimeout(this.getReadTimeout() * 1000L);
        Application.getPrefs().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        LfsEventBus.getInstance().register((Object)this);
    }

    public static synchronized LfsConnector getInstance() {
        if (instance == null) {
            instance = new LfsConnector();
        }
        return instance;
    }

    public boolean isConnectedTo(String host, int port, boolean ssl) {
        if (this.getConnection() == null) {
            return false;
        }
        return ConnectionProfile.getInstance().isConnectedTo(host, port, ssl);
    }

    public void connect(IProgressMonitor monitor) throws Exception {
        boolean serverMode = Application.isServerMode();
        try {
            if (serverMode) {
                monitor.subTask("Starting embedded mode...");
                log.info("Starting embedded mode...");
                this.connection = new LfsEmbeddedSession(monitor);
                this.connection.connect();
                ConnectionProfile.getInstance().init(this.connection, null);
                this.dumpConnectionInfo();
                monitor.subTask("Initialized ok");
            } else {
                Workspace ws = WorkspaceHolder.getInstance().getCurrentWorkspace();
                monitor.subTask("Connecting to " + ws.getServerHost() + ":" + ws.getServerPort());
                log.info("Connecting to {}:{}", (Object)ws.getServerHost(), (Object)ws.getServerPort());
                this.connection = (LfsRemote)this.factory.create(LfsRemote.class, ws.getConnectionUrl());
                Compatibility.isServerCompatible(this.connection);
                this.sid = this.connection.connect();
                ConnectionProfile.getInstance().init(this.connection, ws);
                this.watchdog = new Watchdog();
                this.watchdog.start();
                if (this.sid == null) {
                    monitor.subTask("login required");
                    this.loginRequired = true;
                } else {
                    this.loginRequired = false;
                    monitor.subTask("Setting up repository");
                    this.reloadRepository();
                    monitor.subTask("Connected");
                    LfsEventBus.getInstance().post((Object)LfcEvent.connection(this.connection));
                }
                ws.setLoginRequired(this.loginRequired);
            }
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
            this.terminate();
            monitor.setCanceled(true);
            if (ex instanceof Error) {
                throw new Exception(ex);
            }
            String error = ex.getMessage();
            Throwable cause = ex.getCause();
            if (cause != null && cause instanceof HessianProtocolException) {
                error = String.format("Server is not compatible with this client.\nPlease consider upgrading your server.\n\nReason: %s", cause.getMessage());
            } else if (cause != null && cause instanceof HessianServiceException) {
                error = String.format("Server is not compatible with this client.\nPlease consider upgrading your server.\n\nReason: %s", cause.getMessage());
            } else if (cause != null && cause instanceof SocketException) {
                error = String.format("Unable to connect to specified host.\n\nPlease make sure that you specified correct host, port and security parameters matching the logFaces server on the other end.\n\nReason: %s", cause.getMessage());
            }
            throw new Exception(error);
        }
        monitor.setCanceled(false);
        monitor.done();
    }

    public boolean login(String user, String pwd) {
        block7: {
            if (!this.loginRequired) {
                return true;
            }
            LfsRemote conn = this.getConnection();
            if (conn == null) {
                return false;
            }
            try {
                log.info("attemp to login as {}", (Object)user);
                this.sid = this.connection.login(user, pwd);
                if (this.sid != null) break block7;
                return false;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        try {
            MdcMap.setMap((Map)this.connection.getMdcMapping());
            LfsLevel.addCustomLevels((Map)this.connection.getCustomLevels());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.loginRequired = false;
        LfsEventBus.getInstance().post((Object)LfcEvent.connection(this.connection));
        this.reloadRepository();
        return true;
    }

    public synchronized void terminate() {
        try {
            if (this.watchdog != null) {
                this.watchdog.stop();
            }
            if (this.connection != null && (this.sid != null || this.connection instanceof LfsEmbeddedSession)) {
                this.connection.disconnect(this.sid);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.watchdog = null;
        this.connection = null;
        this.sid = null;
        this.loginRequired = false;
        this.alerts.clear();
        this.lastAlertTime = 0L;
        if (!Application.isExiting()) {
            RepositoryModel.getInstance().clear();
            LfsEventBus.getInstance().post((Object)LfcEvent.connection(null));
        }
    }

    public synchronized void reloadRepository() throws Exception {
        if (this.connection == null) {
            return;
        }
        FetchRepoJob job = new FetchRepoJob();
        job.setUser(true);
        job.schedule();
    }

    public synchronized LfsRemote getConnection() {
        return this.connection;
    }

    public synchronized boolean isConnected() {
        return this.connection != null && !this.loginRequired;
    }

    public synchronized String getSid() {
        return this.sid;
    }

    public synchronized void checkConnection() {
        if (this.sid == null || this.connection == null) {
            return;
        }
        try {
            this.connection.isAlive(this.sid);
        }
        catch (Throwable e) {
            log.warn("connection is stale, discarded ({})", (Object)e.getMessage());
            this.connection = null;
            this.sid = null;
            LfsEventBus.getInstance().post((Object)LfcEvent.connection(this.connection));
        }
    }

    private synchronized boolean reconnect() {
        block4: {
            if (this.loginRequired) {
                return false;
            }
            try {
                Workspace ws = WorkspaceHolder.getInstance().getCurrentWorkspace();
                this.connection = (LfsRemote)this.factory.create(LfsRemote.class, ws.getConnectionUrl());
                this.sid = this.connection.connect();
                ConnectionProfile.getInstance().init(this.connection, ws);
                if (this.sid != null) break block4;
                this.loginRequired = true;
                LoginHandler.getInstance().login();
                return false;
            }
            catch (Exception e) {
                this.connection = null;
                return false;
            }
        }
        LfsEventBus.getInstance().post((Object)LfcEvent.connection(this.connection));
        this.reloadRepository();
        return true;
    }

    private synchronized void handleAlerts() {
        if (!Compatibility.canUseAlerts() && Application.getPrefs().getBoolean("show_alerts", true)) {
            return;
        }
        try {
            boolean notify = false;
            boolean pins = false;
            List list = this.connection.listAlerts(this.sid, this.lastAlertTime, 1000L);
            if (list == null) {
                notify = this.lastAlertTime == 0L;
            } else {
                notify = this.alerts.size() != list.size() || !this.alerts.containsAll(list);
                this.alerts = list;
            }
            this.lastAlertTime = System.currentTimeMillis();
            if (!notify) {
                return;
            }
            for (AlertVO alert : Lists.newArrayList(this.alerts)) {
                if (!alert.isPin()) continue;
                this.alerts.remove(alert);
                pins = true;
            }
            if (pins) {
                LfsEventBus.getInstance().post((Object)LfcEvent.pins());
            }
            if (!this.alerts.isEmpty()) {
                LfsEventBus.getInstance().post((Object)LfcEvent.alerts(this.alerts));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isLoginRequired() {
        return this.loginRequired;
    }

    public long getReadTimeout() {
        return Application.getPrefs().getInt("lfs_read_timeout", 60);
    }

    public long getPollingTimeout() {
        return this.getReadTimeout() / 2L;
    }

    public List<AlertVO> getAlerts() {
        return Lists.newArrayList(this.alerts);
    }

    public synchronized void ackAlerts(List<Long> aids) throws Exception {
        if (this.sid != null) {
            this.getConnection().ackAlerts(this.sid, aids);
            if (aids == null || aids.isEmpty()) {
                this.alerts.clear();
            } else {
                for (AlertVO alert : Lists.newArrayList(this.alerts)) {
                    if (!aids.contains(alert.getTime())) continue;
                    this.alerts.remove(alert);
                }
            }
            LfsEventBus.getInstance().post((Object)LfcEvent.alerts(this.alerts));
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String key = event.getKey();
        if ("lfs_read_timeout".equals(key)) {
            this.factory.setReadTimeout(this.getReadTimeout() * 1000L);
            return;
        }
        if ("show_alerts".equals(key)) {
            if (!Application.getPrefs().getBoolean("show_alerts", true)) {
                this.alerts.clear();
            }
            return;
        }
    }

    @Subscribe
    public void handleLfcEvent(LfcEvent event) {
        if (event.is(LfcEvent.TYPE.CONNECTED)) {
            this.dumpConnectionInfo();
        }
    }

    private void dumpConnectionInfo() {
        try {
            LfsRemote connection = LfsConnector.getInstance().getConnection();
            if (connection == null) {
                return;
            }
            StringBuffer buff = new StringBuffer();
            buff.append(String.format("%n%n  %1$-15s : %2$s", "connection", Application.isServerMode() ? "embedded" : ConnectionProfile.getInstance().getServerHost()));
            buff.append(String.format("%n  %1$-15s : %2$s", "server revision", ConnectionProfile.getInstance().getRevision()));
            Map lic = connection.getLicenseInfo();
            for (String key : lic.keySet()) {
                buff.append(String.format("%n  %1$-15s : %2$s", key, lic.get(key)));
            }
            buff.append(String.format("%n", new Object[0]));
            log.info("server connection{}", (Object)buff.toString());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    class Watchdog
    implements Runnable {
        boolean shutdown;
        Thread thread;

        Watchdog() {
        }

        void start() {
            this.shutdown = false;
            this.thread = new Thread(this);
            this.thread.start();
        }

        void stop() {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            this.thread.interrupt();
            this.thread = null;
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                if (LfsConnector.this.connection == null && !LfsConnector.this.reconnect()) {
                    try {
                        Thread.sleep(3000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                try {
                    Utils.longSafeSleep(5000);
                    if (LfsConnector.this.sid == null) continue;
                    LfsConnector.this.connection.isAlive(LfsConnector.this.sid);
                    LfsConnector.this.handleAlerts();
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    log.info("connection is stale, reconnecting..");
                    LfsConnector.this.connection = null;
                    LfsConnector.this.sid = null;
                    LfsEventBus.getInstance().post((Object)LfcEvent.connection(LfsConnector.this.connection));
                }
            }
        }
    }
}

