/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.net;

import com.google.common.eventbus.Subscribe;
import com.moonlit.logfaces.client.model.CountersModel;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.net.NotConnectedException;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import com.moonlit.logfaces.server.util.LfsEventBus;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.ui.PartInitException;

public class DashboardClient {
    private static DashboardClient instance;
    private String perspectiveName;
    private Thread pollingThread;
    private boolean activated;
    private boolean initialized;
    private Map<Integer, CriteriaFilter> settings;
    private LfsConnector connector = LfsConnector.getInstance();
    private static Logger log;

    static {
        log = LogManager.getLogger(DashboardClient.class);
    }

    private DashboardClient() {
        this.settings = CountersModel.getInstance().getSettings();
        LfsEventBus.getInstance().register((Object)this);
    }

    public static synchronized DashboardClient getInstance() {
        if (instance == null) {
            instance = new DashboardClient();
        }
        return instance;
    }

    public void activate() throws Exception {
        this.initialize();
        this.activated = true;
    }

    private void initialize() throws Exception {
        if (this.isInitialized() || this.settings.size() == 0) {
            return;
        }
        try {
            LfsRemote connection = this.connector.getConnection();
            if (connection == null) {
                throw new NotConnectedException();
            }
            this.perspectiveName = "counters-" + this.connector.getSid();
            connection.setupCounters(this.connector.getSid(), this.perspectiveName, this.settings);
            connection.activatePerspective(this.connector.getSid(), this.perspectiveName);
            this.setInitialized(true);
            this.pollingThread = new Thread(new PollingHandler());
            this.pollingThread.start();
        }
        catch (Throwable e) {
            throw new PartInitException(e.getMessage());
        }
    }

    private void terminate() {
        this.setInitialized(false);
    }

    @Subscribe
    public void handleLfcEvent(LfcEvent event) {
        if (event.is(LfcEvent.TYPE.CONNECTED) && this.activated) {
            try {
                this.initialize();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else if (event.is(LfcEvent.TYPE.DISCONNECTED) && this.activated) {
            this.terminate();
        }
    }

    public void resetAll() throws Exception {
        LfsRemote connection = LfsConnector.getInstance().getConnection();
        if (connection != null) {
            connection.resetCounters(this.connector.getSid(), this.perspectiveName);
        }
    }

    public synchronized void setup() {
        this.settings = CountersModel.getInstance().getSettings();
        if (this.settings.size() == 0) {
            this.terminate();
            return;
        }
        try {
            if (!this.isInitialized()) {
                this.initialize();
            } else {
                LfsRemote connection = this.connector.getConnection();
                connection.setupCounters(this.connector.getSid(), this.perspectiveName, this.settings);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dashboardUpdated(List<Integer> values) {
    }

    private synchronized boolean isInitialized() {
        return this.initialized;
    }

    private synchronized void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public String getPerspectiveName() {
        return this.perspectiveName;
    }

    class PollingHandler
    implements Runnable {
        PollingHandler() {
        }

        @Override
        public void run() {
            boolean reconnect = false;
            LfsConnector connector = LfsConnector.getInstance();
            while (DashboardClient.this.isInitialized()) {
                try {
                    Map values;
                    LfsRemote connection = connector.getConnection();
                    if (connection == null) {
                        Thread.sleep(3000L);
                        reconnect = true;
                        continue;
                    }
                    if (reconnect) {
                        reconnect = false;
                        DashboardClient.this.perspectiveName = "counters-" + connector.getSid();
                        connection.setupCounters(connector.getSid(), DashboardClient.this.perspectiveName, DashboardClient.this.settings);
                        connection.activatePerspective(connector.getSid(), DashboardClient.this.perspectiveName);
                    }
                    if ((values = connection.pollCounters(connector.getSid(), DashboardClient.this.perspectiveName, LfsConnector.getInstance().getPollingTimeout())) == null) continue;
                    CountersModel.getInstance().setValues(values);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

