/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.net;

import com.google.common.collect.Maps;
import com.moonlit.logfaces.client.Workspace;
import com.moonlit.logfaces.server.conf.MdcMap;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import com.moonlit.logfaces.server.util.Revision;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectionProfile {
    private HashMap<String, Object> profile;
    private static ConnectionProfile instance;
    private static Logger log;

    static {
        log = LogManager.getLogger(ConnectionProfile.class);
    }

    private ConnectionProfile() {
    }

    public static ConnectionProfile getInstance() {
        if (instance == null) {
            instance = new ConnectionProfile();
        }
        return instance;
    }

    public void init(LfsRemote lfs, Workspace ws) {
        try {
            this.profile = Maps.newHashMap();
            this.profile.put("databaseEnabled", lfs.isDatabaseEnabled());
            this.profile.put("databaseDialect", lfs.getDatabaseDialect());
            this.profile.put("revision", lfs.getRevision());
            this.profile.put("customLevels", lfs.getCustomLevels());
            this.profile.put("mdcMapping", lfs.getMdcMapping());
            this.profile.put("licenseInfo", lfs.getLicenseInfo());
            MdcMap.setMap(this.getMdcMapping());
            LfsLevel.addCustomLevels(this.getCustomLevels());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (ws != null) {
            this.profile.put("serverHost", ws.getServerHost());
            this.profile.put("serverPort", ws.getServerPort());
            this.profile.put("serverSsl", ws.isSsl());
        }
    }

    public boolean isDatabaseEnabled() {
        try {
            return (Boolean)this.profile.get("databaseEnabled");
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getDatabaseDialect() {
        try {
            return this.profile.get("databaseDialect").toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean isDbRegexSupported() {
        if (!this.isDatabaseEnabled()) {
            return true;
        }
        String dialect = this.getDatabaseDialect();
        return dialect.equalsIgnoreCase("mongo") || dialect.equalsIgnoreCase("bq");
    }

    public boolean isDbEscapeSql() {
        String dialect = this.getDatabaseDialect();
        return dialect.equalsIgnoreCase("bq") || !dialect.equalsIgnoreCase("mongo");
    }

    public Revision getRevision() {
        try {
            return Revision.parse((String)this.profile.get("revision").toString());
        }
        catch (Exception e) {
            return Revision.getUnknown();
        }
    }

    public Map<Integer, String> getMdcMapping() {
        try {
            return (Map)this.profile.get("mdcMapping");
        }
        catch (Exception e) {
            return Maps.newHashMap();
        }
    }

    public Map<Integer, String> getCustomLevels() {
        try {
            return (Map)this.profile.get("customLevels");
        }
        catch (Exception e) {
            return Maps.newHashMap();
        }
    }

    public Map<String, String> getLicenseInfo() {
        try {
            return (Map)this.profile.get("licenseInfo");
        }
        catch (Exception e) {
            return Maps.newHashMap();
        }
    }

    public boolean isConnectedTo(String host, int port, boolean ssl) {
        return this.getServerHost().equals(host) && this.getServerPort() == port && this.getServerSsl() == ssl;
    }

    public String getServerHost() {
        try {
            return this.profile.get("serverHost").toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public int getServerPort() {
        try {
            return Integer.parseInt(this.profile.get("serverPort").toString());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean getServerSsl() {
        try {
            return Boolean.parseBoolean(this.profile.get("serverSsl").toString());
        }
        catch (Exception e) {
            return false;
        }
    }
}

