/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.net;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.server.core.ReceiverFormat;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class ConnectionDetails {
    IEclipsePreferences prefs;
    private String lfsHost;
    private String currentWorkspace;
    private Set<String> hostNames;
    private int lfsPort = -1;
    private int udpPort = -1;
    private int tcpPort = -1;
    private int udpSysPort = -1;
    private int tcpSysPort = -1;
    private boolean autoLogin;
    private boolean serverMode;
    private boolean tcpEnabled;
    private boolean udpEnabled;
    private boolean tcpSysEnabled;
    private boolean udpSysEnabled;
    private boolean ssl;
    private static Logger log = LogManager.getLogger(ConnectionDetails.class);

    public ConnectionDetails() {
        this(Application.getPrefs());
    }

    public ConnectionDetails(IEclipsePreferences prefs) {
        this.prefs = prefs;
        this.currentWorkspace = prefs.get("lfs_workspace_name", "My workspace");
        this.lfsHost = prefs.get("lfs_host_name", "localhost");
        String temp = prefs.get("lfs_host_names", this.lfsHost);
        this.hostNames = StringUtils.commaDelimitedListToSet(temp);
        this.lfsPort = prefs.getInt("lfs_port_num", 8050);
        this.tcpPort = prefs.getInt("tcp_port_num", 55200);
        this.tcpEnabled = prefs.getBoolean("tcp_enabled", true);
        this.tcpSysPort = prefs.getInt("tcp_sys_port_num", 1468);
        this.tcpSysEnabled = prefs.getBoolean("tcp_sys_enabled", true);
        this.udpPort = prefs.getInt("udp_port_num", 55201);
        this.udpEnabled = prefs.getBoolean("udp_enabled", false);
        this.udpSysPort = prefs.getInt("udp_sys_port_num", 514);
        this.udpSysEnabled = prefs.getBoolean("udp_sys_enabled", false);
        this.serverMode = prefs.getBoolean("server_mode", false);
        this.autoLogin = prefs.getBoolean("lfs_auto_connect", false);
        this.ssl = prefs.getBoolean("lfs_ssl", false);
    }

    public void save() {
        this.prefs.put("lfs_workspace_name", this.currentWorkspace);
        this.prefs.put("lfs_host_name", this.lfsHost);
        this.prefs.put("lfs_host_names", StringUtils.collectionToCommaDelimitedString(this.hostNames));
        this.prefs.putInt("lfs_port_num", this.lfsPort);
        this.prefs.putBoolean("lfs_auto_connect", this.autoLogin);
        this.prefs.putInt("tcp_port_num", this.tcpPort);
        this.prefs.putInt("udp_port_num", this.udpPort);
        this.prefs.putInt("tcp_sys_port_num", this.tcpSysPort);
        this.prefs.putInt("udp_sys_port_num", this.udpSysPort);
        this.prefs.putBoolean("tcp_enabled", this.tcpEnabled);
        this.prefs.putBoolean("udp_enabled", this.udpEnabled);
        this.prefs.putBoolean("tcp_sys_enabled", this.tcpSysEnabled);
        this.prefs.putBoolean("udp_sys_enabled", this.udpSysEnabled);
        this.prefs.putBoolean("server_mode", this.serverMode);
        this.prefs.putBoolean("lfs_ssl", this.ssl);
        try {
            this.prefs.flush();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setAutoLogin(boolean autoLogin) {
        this.autoLogin = autoLogin;
    }

    public void setLfsHost(String host) {
        this.hostNames.add(host);
        this.lfsHost = host;
    }

    public void setLfsPort(int port) {
        this.lfsPort = port;
    }

    public boolean isAutoLogin() {
        return this.autoLogin;
    }

    public String getLfsHost() {
        return this.lfsHost;
    }

    public int getLfsPort() {
        return this.lfsPort;
    }

    public String getResource() {
        return String.valueOf(System.currentTimeMillis());
    }

    public boolean isServerMode() {
        return this.serverMode;
    }

    public void setServerMode(boolean serverMode) {
        this.serverMode = serverMode;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public void setUdpPort(int udpPort) {
        this.udpPort = udpPort;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public void setTcpPort(int tcpPort) {
        this.tcpPort = tcpPort;
    }

    public boolean isTcpEnabled() {
        return this.tcpEnabled;
    }

    public void setTcpEnabled(boolean tcpEnabled) {
        this.tcpEnabled = tcpEnabled;
    }

    public boolean isUdpEnabled() {
        return this.udpEnabled;
    }

    public void setUdpEnabled(boolean udpEnabled) {
        this.udpEnabled = udpEnabled;
    }

    public Set<String> getHostNames() {
        return this.hostNames;
    }

    public String getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    public void setCurrentWorkspace(String currentWorkspace) {
        this.currentWorkspace = currentWorkspace;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public int getUdpSysPort() {
        return this.udpSysPort;
    }

    public void setUdpSysPort(int udpSysPort) {
        this.udpSysPort = udpSysPort;
    }

    public int getTcpSysPort() {
        return this.tcpSysPort;
    }

    public void setTcpSysPort(int tcpSysPort) {
        this.tcpSysPort = tcpSysPort;
    }

    public boolean isTcpSysEnabled() {
        return this.tcpSysEnabled;
    }

    public void setTcpSysEnabled(boolean tcpSysEnabled) {
        this.tcpSysEnabled = tcpSysEnabled;
    }

    public boolean isUdpSysEnabled() {
        return this.udpSysEnabled;
    }

    public void setUdpSysEnabled(boolean udpSysEnabled) {
        this.udpSysEnabled = udpSysEnabled;
    }

    public ReceiverFormat getReceiverFormat(boolean tcp) {
        return tcp ? ReceiverFormat.fromString((String)this.prefs.get("tcp_rx_format", "xml")) : ReceiverFormat.xml;
    }
}

