/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model.filters;

import com.moonlit.logfaces.client.model.filters.LogEventMatcher;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.Operation;
import org.apache.commons.lang3.StringUtils;

public class PropertyMatcher
implements LogEventMatcher {
    private Operation operation;
    private String name;
    private String value;
    private boolean enabled = true;

    public PropertyMatcher(Operation operation, String name, String value) {
        this.operation = operation;
        this.name = name;
        this.value = value;
    }

    @Override
    public boolean match(LogEvent event) {
        if (!this.enabled) {
            return true;
        }
        String mdcValue = (String)event.getProperties().get(this.name);
        if (mdcValue == null) {
            return !this.operation.equals((Object)Operation.is);
        }
        return this.operation.equals((Object)Operation.is) == mdcValue.matches(this.value);
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    public String toString() {
        String unescaped = this.value.toString();
        if (unescaped.contains("\\Q") && unescaped.contains("\\E")) {
            unescaped = StringUtils.remove((String)unescaped, (String)"\\Q");
            unescaped = StringUtils.remove((String)unescaped, (String)"\\E");
        }
        return String.format("%s %s '%s'", this.name, this.operation.equals((Object)Operation.is) ? "is" : "is not", unescaped);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

