/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model.filters;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.Columns;
import com.moonlit.logfaces.client.model.filters.AttributeMatcher;
import com.moonlit.logfaces.client.model.filters.ComponentMatcher;
import com.moonlit.logfaces.client.model.filters.LogEventMatcher;
import com.moonlit.logfaces.client.model.filters.LogViewFilter;
import com.moonlit.logfaces.client.model.filters.PropertyMatcher;
import com.moonlit.logfaces.server.conf.MdcMap;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import java.util.ArrayList;
import java.util.List;

public class LogViewFilterImpl
implements LogViewFilter {
    private List<LogEventMatcher> focus = Lists.newArrayList();
    private List<LogEventMatcher> hides = Lists.newArrayList();

    @Override
    public boolean pass(LogEvent event) {
        for (LogEventMatcher matcher : this.hides) {
            if (matcher.match(event)) continue;
            return false;
        }
        for (LogEventMatcher matcher : this.focus) {
            if (matcher.match(event)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setFocus(int column, String value) {
        LogEventMatcher matcher = null;
        switch (column) {
            case 0: {
                matcher = new AttributeMatcher(EventAttribute.loggerLevel, Operation.is, value == null ? LfsLevel.ALL.intLevel() : LfsLevel.toLevel((String)value).intLevel());
                break;
            }
            case 5: {
                matcher = new AttributeMatcher(EventAttribute.domainName, Operation.is, value);
                break;
            }
            case 4: {
                matcher = new AttributeMatcher(EventAttribute.hostName, Operation.is, value);
                break;
            }
            case 7: {
                matcher = new AttributeMatcher(EventAttribute.loggerName, Operation.is, value);
                break;
            }
            case 8: {
                matcher = new AttributeMatcher(EventAttribute.threadName, Operation.is, value);
                break;
            }
            case 10: {
                matcher = new AttributeMatcher(EventAttribute.thrown, Operation.is, value != null);
                break;
            }
            case 12: {
                if (!((String)value).startsWith("*")) {
                    value = "*" + (String)value;
                }
                if (!((String)value).endsWith("*")) {
                    value = (String)value + "*";
                }
                matcher = new AttributeMatcher(EventAttribute.message, Operation.is, value);
                break;
            }
            case 1: {
                matcher = new PropertyMatcher(Operation.is, "tags", (String)value);
                break;
            }
            case 6: {
                matcher = new ComponentMatcher(Operation.is, (String)value);
            }
        }
        if (Columns.isMdcColumn(column)) {
            String name = MdcMap.getName((int)MdcMap.getKey((String)Columns.column2mdc(column)));
            matcher = new PropertyMatcher(Operation.is, name, (String)value);
        }
        this.addMatcher(matcher);
    }

    @Override
    public List<LogEventMatcher> getMatchers() {
        ArrayList list = Lists.newArrayList(this.focus);
        list.addAll(this.hides);
        return list;
    }

    @Override
    public void addMatcher(LogEventMatcher matcher) {
        if (matcher.getOperation().equals((Object)Operation.is)) {
            this.focus.add(matcher);
        } else {
            this.hides.add(matcher);
        }
    }

    @Override
    public void reset() {
        this.focus.clear();
        this.hides.clear();
    }
}

