/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model.filters;

import com.moonlit.logfaces.client.model.ComponentsModel;
import com.moonlit.logfaces.client.model.filters.LogEventMatcher;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import org.apache.commons.lang3.StringUtils;

public class ComponentMatcher
implements LogEventMatcher {
    private Operation operation;
    private String component;
    private boolean enabled = true;

    public ComponentMatcher(Operation operation, String component) {
        this.operation = operation;
        this.component = component;
    }

    @Override
    public boolean match(LogEvent event) {
        if (!this.enabled) {
            return true;
        }
        if (!(event instanceof LoggingEventVO)) {
            return false;
        }
        LoggingEventVO vo = (LoggingEventVO)event;
        String comp = ComponentsModel.getInstance().getComponent(vo);
        return this.operation.equals((Object)Operation.is) == comp.matches(this.component);
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    public String toString() {
        String escaped = this.component.toString();
        if (escaped.contains("\\Q") && escaped.contains("\\E")) {
            escaped = StringUtils.remove((String)escaped, (String)"\\Q");
            escaped = StringUtils.remove((String)escaped, (String)"\\E");
        }
        return String.format("component %s '%s'", this.operation.equals((Object)Operation.is) ? "is" : "is not", escaped);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

