/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model.filters;

import com.moonlit.logfaces.client.model.filters.LogEventMatcher;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.util.WildCardMatcher;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import org.apache.commons.lang3.StringUtils;

public class AttributeMatcher
implements LogEventMatcher {
    private WildCardMatcher wildcards = new WildCardMatcher();
    private EventAttribute attribute;
    private Operation operation;
    private Object value;
    private boolean enabled = true;

    public AttributeMatcher(EventAttribute attribute, Operation operation, Object value) {
        this.attribute = attribute;
        this.operation = operation;
        this.value = value;
    }

    public AttributeMatcher(Operation operation) {
        this.attribute = EventAttribute.message;
        this.operation = operation;
        this.value = "";
    }

    @Override
    public boolean match(LogEvent event) {
        if (!(event instanceof LoggingEventVO)) {
            return false;
        }
        if (!this.enabled) {
            return true;
        }
        LoggingEventVO vo = (LoggingEventVO)event;
        switch (this.attribute) {
            case loggerLevel: {
                return vo.getLoggerLevel() >= Integer.parseInt(this.value.toString());
            }
            case domainName: {
                return this.operation.equals((Object)Operation.is) == vo.getDomainName().matches(this.value.toString());
            }
            case hostName: {
                return this.operation.equals((Object)Operation.is) == vo.getHostName().matches(this.value.toString());
            }
            case loggerName: {
                return this.operation.equals((Object)Operation.is) == vo.getLoggerName().matches(this.value.toString());
            }
            case threadName: {
                return this.operation.equals((Object)Operation.is) == vo.getThreadName().matches(this.value.toString());
            }
            case message: {
                return this.operation.equals((Object)Operation.is) == this.wildcards.isStringMatching(vo.getMessage(), this.value.toString());
            }
            case thrown: {
                return this.operation.equals((Object)Operation.is) == this.value.equals(vo.isThrown());
            }
        }
        return false;
    }

    public String toString() {
        if (this.attribute == EventAttribute.loggerLevel) {
            return String.format("severity level is or above '%s'", LfsLevel.toLevel((int)Integer.parseInt(this.value.toString())));
        }
        if (this.attribute == EventAttribute.thrown) {
            return "only thrown exceptions";
        }
        String escaped = this.value.toString();
        if (escaped.contains("\\Q") && escaped.contains("\\E")) {
            escaped = StringUtils.remove((String)escaped, (String)"\\Q");
            escaped = StringUtils.remove((String)escaped, (String)"\\E");
        }
        return String.format("%s %s '%s'", this.attribute, this.operation.equals((Object)Operation.is) ? "is" : "is not", escaped);
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    public EventAttribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(EventAttribute attribute) {
        this.attribute = attribute;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

