/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model.data;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.Columns;
import com.moonlit.logfaces.client.model.ComponentsModel;
import com.moonlit.logfaces.client.model.filters.LogEventMatcher;
import com.moonlit.logfaces.client.model.filters.LogViewFilter;
import com.moonlit.logfaces.server.conf.MdcMap;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.util.WildCardMatcher;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ViewFilter
implements LogViewFilter {
    private int focusSeverity = LfsLevel.ALL.intLevel();
    private String focusDomain = null;
    private String focusComponent = null;
    private String focusHost = null;
    private String focusLogger = null;
    private String focusThread = null;
    private String focusTag = null;
    private boolean focusThrown = false;
    private String focusMessage = null;
    private int focusMdcKey = -1;
    private String focusMdcValue = null;
    private WildCardMatcher wildcards = new WildCardMatcher();
    private ComponentsModel components = ComponentsModel.getInstance();
    private List<String> ignoreDomains = new ArrayList<String>();
    private List<String> ignoreComponent = new ArrayList<String>();
    private List<String> ignoreHosts = new ArrayList<String>();
    private List<String> ignoreLoggers = new ArrayList<String>();
    private List<String> ignoreThreads = new ArrayList<String>();
    private List<String> ignoreMessages = new ArrayList<String>();
    private List<String> ignoreMdc = new ArrayList<String>();
    private List<String> ignoreTags = new ArrayList<String>();

    @Override
    public boolean pass(LogEvent event) {
        return this.pass((LoggingEventVO)event);
    }

    @Override
    public List<LogEventMatcher> getMatchers() {
        return Lists.newArrayList();
    }

    @Override
    public void addMatcher(LogEventMatcher matcher) {
    }

    public boolean pass(LoggingEventVO event) {
        if (this.shouldIgnore(event)) {
            return false;
        }
        return this.shouldFocus(event);
    }

    protected boolean shouldIgnore(LoggingEventVO event) {
        if (event.getDomainName() != null && this.ignoreDomains.contains(event.getDomainName())) {
            return true;
        }
        if (event.getHostName() != null && this.ignoreHosts.contains(event.getHostName())) {
            return true;
        }
        if (event.getLoggerName() != null && this.ignoreLoggers.contains(event.getLoggerName())) {
            return true;
        }
        if (!this.ignoreComponent.isEmpty() && this.ignoreComponent.contains(this.components.getComponent(event))) {
            return true;
        }
        if (event.getThreadName() != null && this.ignoreThreads.contains(event.getThreadName())) {
            return true;
        }
        if (event.getMessage() != null) {
            for (String text : this.ignoreMessages) {
                if (!this.wildcards.isStringMatching(event.getMessage(), text)) continue;
                return true;
            }
        }
        if (!this.ignoreMdc.isEmpty()) {
            Iterator<String> iterator = MdcMap.getKeys().iterator();
            while (iterator.hasNext()) {
                int mdcKey = (Integer)((Object)iterator.next());
                String value = event.getProperty(MdcMap.getName((int)mdcKey));
                if (value == null || !this.ignoreMdc.contains(value)) continue;
                return true;
            }
        }
        if (!this.ignoreTags.isEmpty()) {
            String tags = (String)event.getProperties().get("tags");
            if (tags == null) {
                return false;
            }
            for (String tag : this.ignoreTags) {
                if (!tags.contains(tag)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean shouldFocus(LoggingEventVO event) {
        if (this.focusSeverity > event.getLoggerLevel()) {
            return false;
        }
        if (this.focusDomain != null && event.getDomainName() != null && !event.getDomainName().matches(this.focusDomain)) {
            return false;
        }
        if (this.focusTag != null) {
            String tags = (String)event.getProperties().get("tags");
            if (tags == null) {
                return false;
            }
            if (!tags.matches(this.focusTag)) {
                return false;
            }
        }
        if (this.focusComponent != null && !this.components.getComponent(event).matches(this.focusComponent)) {
            return false;
        }
        if (this.focusHost != null && event.getHostName() != null && !event.getHostName().matches(this.focusHost)) {
            return false;
        }
        if (this.focusLogger != null && event.getLoggerName() != null && !this.wildcards.isStringMatching(event.getLoggerName(), this.focusLogger)) {
            return false;
        }
        if (this.focusThread != null && event.getThreadName() != null && !event.getThreadName().matches(this.focusThread)) {
            return false;
        }
        if (this.focusThrown && !event.isThrown()) {
            return false;
        }
        if (this.focusMessage != null && event.getMessage() != null && !this.wildcards.isStringMatching(event.getMessage(), this.focusMessage)) {
            return false;
        }
        if (this.focusMdcKey != -1 && this.focusMdcValue != null) {
            String value = event.getProperty(MdcMap.getName((int)this.focusMdcKey));
            if (value == null) {
                return false;
            }
            if (!value.matches(this.focusMdcValue)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void reset() {
        this.focusSeverity = LfsLevel.ALL.intLevel();
        this.ignoreDomains.clear();
        this.ignoreComponent.clear();
        this.ignoreHosts.clear();
        this.ignoreLoggers.clear();
        this.ignoreThreads.clear();
        this.ignoreMessages.clear();
        this.ignoreMdc.clear();
        this.ignoreTags.clear();
        this.focusDomain = null;
        this.focusTag = null;
        this.focusComponent = null;
        this.focusHost = null;
        this.focusLogger = null;
        this.focusThread = null;
        this.focusThrown = false;
        this.focusMessage = null;
        this.focusMdcKey = -1;
        this.focusMdcValue = null;
    }

    public String getFocusHost() {
        return this.focusHost;
    }

    public void setFocusHost(String focusHost) {
        this.focusHost = focusHost;
    }

    public String getFocusLogger() {
        return this.focusLogger;
    }

    public void setFocusLogger(String focusLogger) {
        this.focusLogger = focusLogger;
    }

    public String getFocusThread() {
        return this.focusThread;
    }

    public void setFocusThread(String focusThread) {
        this.focusThread = focusThread;
    }

    public String getFocusMessage() {
        return this.focusMessage;
    }

    public void setFocusMessage(String focusMessage) {
        this.focusMessage = focusMessage;
    }

    public void setFocusMdc(int key, String value) {
        this.focusMdcKey = key;
        this.focusMdcValue = value;
    }

    public void addIgnoreMdc(String value) {
        this.ignoreMdc.add(value);
    }

    public void addIgnoreDomain(String domain) {
        this.ignoreDomains.add(domain);
    }

    public void addIgnoreTag(String tag) {
        this.ignoreTags.add(tag);
    }

    public void addIgnoreComponent(String component) {
        this.ignoreComponent.add(component);
    }

    public void addIgnoreHost(String host) {
        this.ignoreHosts.add(host);
    }

    public void addIgnoreLogger(String logger) {
        this.ignoreLoggers.add(logger);
    }

    public void addIgnoreThread(String thread) {
        this.ignoreThreads.add(thread);
    }

    public void addIgnoreMessage(String message) {
        this.ignoreMessages.add(message);
    }

    public void setFocusSeverity(int focusSeverity) {
        this.focusSeverity = focusSeverity;
    }

    public String getFocusDomain() {
        return this.focusDomain;
    }

    public void setFocusDomain(String focusDomain) {
        this.focusDomain = focusDomain;
    }

    public String getFocusTag() {
        return this.focusTag;
    }

    public void setFocusTag(String tag) {
        this.focusTag = tag;
    }

    public String getFocusComponent() {
        return this.focusComponent;
    }

    public void setFocusComponent(String focusComponent) {
        this.focusComponent = focusComponent;
    }

    public boolean isFocusThrown() {
        return this.focusThrown;
    }

    public void setFocusThrown(boolean focusThrown) {
        this.focusThrown = focusThrown;
    }

    @Override
    public void setFocus(int column, String value) {
        switch (column) {
            case 0: {
                this.focusSeverity = value == null ? LfsLevel.ALL.intLevel() : LfsLevel.toLevel((String)value).intLevel();
                return;
            }
            case 5: {
                this.focusDomain = value;
                return;
            }
            case 1: {
                this.focusTag = value;
                return;
            }
            case 6: {
                this.focusComponent = value;
                return;
            }
            case 4: {
                this.focusHost = value;
                return;
            }
            case 7: {
                this.focusLogger = value;
                return;
            }
            case 8: {
                this.focusThread = value;
                return;
            }
            case 10: {
                this.focusThrown = value != null;
                return;
            }
            case 12: {
                if (value == null) {
                    this.focusMessage = null;
                    return;
                }
                if (!((String)value).startsWith("*")) {
                    value = "*" + (String)value;
                }
                if (!((String)value).endsWith("*")) {
                    value = (String)value + "*";
                }
                this.focusMessage = value;
                return;
            }
        }
        if (Columns.isMdcColumn(column)) {
            this.focusMdcKey = MdcMap.getKey((String)Columns.column2mdc(column));
            this.focusMdcValue = value;
        }
    }
}

