/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model.data;

import com.moonlit.logfaces.client.dashboard.SliceInfo;
import com.moonlit.logfaces.client.model.ComponentsModel;
import com.moonlit.logfaces.client.model.data.BaseProjection;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.vo.LoggingEventVO;

public class SimpleProjection
extends BaseProjection {
    public SimpleProjection(LogDataModel model, SliceInfo slice, TimeRange requestedRate) {
        super(model, slice, requestedRate);
        this.create();
    }

    @Override
    protected void project(LogEvent e) {
        if (!(e instanceof LoggingEventVO)) {
            return;
        }
        String value = null;
        LoggingEventVO event = (LoggingEventVO)e;
        block0 : switch (this.slice.getType()) {
            case components: {
                value = ComponentsModel.getInstance().getComponent(event);
                value = StringUtils.hasText(value) ? value : null;
                break;
            }
            case tags: {
                value = (String)event.getProperties().get("tags");
                break;
            }
            case mdc: {
                value = event.getProperty(this.slice.getName());
                break;
            }
            case attributes: {
                switch (this.slice.getAttribute()) {
                    case domainName: {
                        value = event.getDomainName();
                        break block0;
                    }
                    case hostName: {
                        value = event.getHostName();
                        break block0;
                    }
                    case loggerName: {
                        value = event.getLoggerName();
                        break block0;
                    }
                    case threadName: {
                        value = event.getThreadName();
                        break block0;
                    }
                    case throwableInfo: {
                        value = event.getExceptionClass();
                        break block0;
                    }
                    case loggerLevel: {
                        value = LfsLevel.toLevel((int)event.getLoggerLevel()).name();
                        break block0;
                    }
                }
            }
        }
        this.increment(event.getLoggerTimeStamp(), value);
    }
}

