/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model.data;

import com.moonlit.logfaces.client.dashboard.SliceInfo;
import com.moonlit.logfaces.client.model.RegexModel;
import com.moonlit.logfaces.client.model.RegexVO;
import com.moonlit.logfaces.client.model.data.BaseProjection;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.server.core.LogEvent;
import java.util.List;
import java.util.TreeMap;

public class RegexPatternProjection
extends BaseProjection {
    private RegexVO regex;

    public RegexPatternProjection(LogDataModel model, SliceInfo slice, TimeRange requestedRate) {
        super(model, slice, requestedRate);
        this.regex = RegexModel.getInstance().get(slice.getName());
        this.create();
    }

    @Override
    protected void create() {
        List<LogEvent> data = this.model.getViewData();
        if (data.isEmpty()) {
            return;
        }
        this.fromTime = data.get(0).getLoggerTimeStamp();
        this.toTime = data.get(data.size() - 1).getLoggerTimeStamp();
        this.rate = this.requestedRate.getRangeAdjusted(this.toTime - this.fromTime, 100);
        long time = this.fromTime;
        while (time <= this.toTime) {
            this.results.add(new TreeMap());
            time += this.rate;
        }
        for (LogEvent event : data) {
            String value = this.regex.extract(event.getMessage());
            this.increment(event.getLoggerTimeStamp(), value);
        }
    }
}

