/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model.data;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.dashboard.SliceInfo;
import com.moonlit.logfaces.client.model.RegexModel;
import com.moonlit.logfaces.client.model.RegexVO;
import com.moonlit.logfaces.client.model.data.BaseProjection;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.vo.StatVO;
import java.util.ArrayList;
import java.util.List;

public class NumericPatternProjection
extends BaseProjection {
    private RegexVO regex;
    private List<StatVO> results = Lists.newArrayList();

    public NumericPatternProjection(LogDataModel model, SliceInfo slice, TimeRange requestedRate) {
        super(model, slice, requestedRate);
        this.regex = RegexModel.getInstance().get(slice.getName());
        this.create();
    }

    @Override
    protected void create() {
        List<LogEvent> data = this.model.getViewData();
        if (data.isEmpty()) {
            return;
        }
        this.fromTime = data.get(0).getLoggerTimeStamp();
        this.toTime = data.get(data.size() - 1).getLoggerTimeStamp();
        this.rate = this.requestedRate.getRangeAdjusted(this.toTime - this.fromTime, 100);
        long time = this.fromTime;
        while (time <= this.toTime) {
            StatVO stat = new StatVO();
            stat.setT1(time);
            stat.setT2(time + this.rate);
            stat.setProjection(this.regex.getName());
            this.results.add(stat);
            time += this.rate;
        }
        for (LogEvent event : data) {
            String value = this.regex.extract(event.getMessage());
            this.increment(event.getLoggerTimeStamp(), value);
        }
    }

    @Override
    public List<StatVO> getProjection() {
        ArrayList ret = Lists.newArrayList();
        for (StatVO vo : this.results) {
            if (!(vo.getCount() > 0.0f)) continue;
            ret.add(vo);
        }
        return ret;
    }

    @Override
    protected void increment(long time, String value) {
        long index = (time - this.fromTime) / this.rate;
        if (index < 0L || index >= (long)this.results.size()) {
            return;
        }
        StatVO bucket = this.results.get((int)index);
        if (bucket == null) {
            return;
        }
        try {
            bucket.increment(Float.parseFloat(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

