/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.moonlit.logfaces.client.Columns;
import com.moonlit.logfaces.client.dashboard.SliceInfo;
import com.moonlit.logfaces.client.model.ComponentsModel;
import com.moonlit.logfaces.client.model.EventStyle;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.model.PerspectiveVO;
import com.moonlit.logfaces.client.model.RegexModel;
import com.moonlit.logfaces.client.model.RegexVO;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.model.data.Annotation;
import com.moonlit.logfaces.client.model.data.AnnotationManager;
import com.moonlit.logfaces.client.model.data.AnnotationType;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.client.model.data.LogModelEvent;
import com.moonlit.logfaces.client.model.data.LogModelListener;
import com.moonlit.logfaces.client.model.data.TagsModelListener;
import com.moonlit.logfaces.client.model.data.ViewFilter;
import com.moonlit.logfaces.client.model.filters.LogViewFilter;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.client.widgets.BalloonHandler;
import com.moonlit.logfaces.server.conf.MdcMap;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.widgets.Display;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;

public class Log4jModel
implements LogDataModel,
TagsModelListener {
    private EventStyles styles = EventStyles.getInstance();
    private TagsModel tagsModel = TagsModel.getInstance();
    private LogViewFilter filter;
    private LogEvent drillEvent;
    private LogEvent selectedEvent;
    private List<LogEvent> model;
    private List<LogEvent> viewData;
    private AnnotationManager annotations;
    private Set<LogModelListener> listeners;
    private ComponentsModel components = ComponentsModel.getInstance();
    private BalloonHandler balloons = BalloonHandler.getInstance();
    private boolean autoclear;
    private int maxSize = Integer.MAX_VALUE;
    private long lastWakeTime;

    public Log4jModel() {
        this.model = new CopyOnWriteArrayList<LogEvent>();
        this.viewData = new CopyOnWriteArrayList<LogEvent>();
        this.annotations = new AnnotationManager();
        this.listeners = new HashSet<LogModelListener>();
        this.filter = new ViewFilter();
        this.tagsModel.addListener(this);
    }

    @Override
    public void destroy() {
        this.tagsModel.removeListener(this);
        this.model.clear();
        this.viewData.clear();
        this.annotations.clear();
        this.removeBookmark(this.drillEvent);
    }

    @Override
    public void handleTagsChange(Collection<String> tags) {
        if (tags == null || tags.isEmpty()) {
            return;
        }
        for (LogEvent event : this.model) {
            if (this.tagsModel.untag(event, tags)) {
                this.annotations.remove(new Annotation(event, AnnotationType.TAG, this.viewData.indexOf(event)));
            }
            if (this.tagsModel.isTagged(event) || !this.tagsModel.tag(event)) continue;
            this.annotations.add(AnnotationType.TAG, event, this.viewData.indexOf(event));
        }
        this.fireUpdate(LogModelEvent.RETAG);
    }

    @Override
    public boolean add(LogEvent e) {
        if (!(e instanceof LoggingEventVO)) {
            return false;
        }
        if (this.model.size() >= this.maxSize) {
            if (this.autoclear) {
                this.clear();
            } else {
                this.manageSize();
            }
        }
        LoggingEventVO event = (LoggingEventVO)e;
        this.model.add((LogEvent)event);
        this.tagsModel.tag((LogEvent)event);
        if (event.getMessage().isEmpty() && event.isThrown()) {
            event.setMessage(Utils.getExceptionClass(event));
        }
        if (event.getSequenceNumber() == 0L) {
            event.setSequenceNumber((long)this.model.size());
        }
        if (this.filter.pass((LogEvent)event)) {
            this.viewData.add((LogEvent)event);
            this.annotate((LogEvent)event, this.viewData.size() - 1);
            return true;
        }
        return false;
    }

    @Override
    public void addAll(Collection<LogEvent> events) {
        if (events == null) {
            return;
        }
        for (LogEvent event : events) {
            this.add(event);
        }
        this.fireUpdate(LogModelEvent.ADDED);
    }

    @Override
    public void addAndFilter(List<LogEvent> events, PerspectiveVO pvo) {
        if (events == null) {
            return;
        }
        int nudgeSound = pvo.getNudge();
        int wakeSound = pvo.getWakeSound();
        boolean baloon = pvo.isBaloon();
        for (LogEvent e : events) {
            LoggingEventVO event;
            if (!(e instanceof LoggingEventVO) || !this.add((LogEvent)(event = (LoggingEventVO)e))) continue;
            if (baloon && (event.getLoggerLevel() >= 30000 || event.isThrown())) {
                this.balloons.show(event);
            }
            if (nudgeSound != 0) {
                Utils.chime(event, nudgeSound);
            } else if (wakeSound != 0 && System.currentTimeMillis() - this.lastWakeTime > 60000L) {
                Utils.chime(wakeSound);
            }
            this.lastWakeTime = System.currentTimeMillis();
        }
        this.fireUpdate(LogModelEvent.ADDED);
    }

    protected void annotate(LogEvent e, int location) {
        LoggingEventVO event = (LoggingEventVO)e;
        switch (event.getLoggerLevel()) {
            case 30000: {
                this.annotations.add(AnnotationType.WARNING, (LogEvent)event, location);
                break;
            }
            case 40000: {
                this.annotations.add(AnnotationType.ERROR, (LogEvent)event, location);
                break;
            }
            case 50000: {
                this.annotations.add(AnnotationType.FATAL, (LogEvent)event, location);
            }
        }
        if (this.tagsModel.isTagged((LogEvent)event) || this.tagsModel.tag((LogEvent)event)) {
            this.annotations.add(AnnotationType.TAG, (LogEvent)event, location);
        }
        if (this.tagsModel.isBookmark((LogEvent)event)) {
            this.annotations.add(AnnotationType.BOOKMARK, (LogEvent)event, location);
        }
    }

    @Override
    public void applyCriteria(CriteriaFilter criteria) {
        criteria.prepare();
        ArrayList<LogEvent> toremove = new ArrayList<LogEvent>();
        for (LogEvent event : this.model) {
            if (criteria.qualify((Object)event)) continue;
            toremove.add(event);
        }
        this.model.removeAll(toremove);
        this.refresh();
    }

    @Override
    public Map<String, Integer> slice(SliceInfo slice) {
        HashMap result = Maps.newHashMap();
        String value = null;
        for (LogEvent e : this.viewData) {
            LoggingEventVO event = (LoggingEventVO)e;
            block0 : switch (slice.getType()) {
                case components: {
                    value = this.components.getComponent(event);
                    break;
                }
                case tags: {
                    value = (String)event.getProperties().get("tags");
                    break;
                }
                case regex: {
                    RegexVO regex = RegexModel.getInstance().get(slice.getName());
                    value = regex.extract(event.getMessage());
                    break;
                }
                case mdc: {
                    value = event.getProperty(slice.getName());
                    break;
                }
                case attributes: {
                    switch (slice.getAttribute()) {
                        case domainName: {
                            value = event.getDomainName();
                            break block0;
                        }
                        case hostName: {
                            value = event.getHostName();
                            break block0;
                        }
                        case loggerName: {
                            value = event.getLoggerName();
                            break block0;
                        }
                        case threadName: {
                            value = event.getThreadName();
                            break block0;
                        }
                        case throwableInfo: {
                            value = event.getExceptionClass();
                            break block0;
                        }
                        case loggerLevel: {
                            value = LfsLevel.toLevel((int)event.getLoggerLevel()).toString();
                            break block0;
                        }
                    }
                    break;
                }
            }
            if (!StringUtils.hasText(value)) continue;
            result.put(value, result.containsKey(value) ? (Integer)result.get(value) + 1 : 1);
        }
        return result;
    }

    @Override
    public void clear() {
        if (this.model.isEmpty()) {
            return;
        }
        this.model.clear();
        this.refresh();
    }

    protected void manageSize() {
        if (this.model.size() < this.maxSize + this.maxSize / 5) {
            return;
        }
        List<LogEvent> toremove = this.model.subList(0, this.maxSize / 5);
        this.viewData.removeAll(toremove);
        this.annotations.trim(toremove.size());
        toremove.clear();
        toremove = null;
        this.fireUpdate(LogModelEvent.TRIMMED);
    }

    @Override
    public boolean isEmpty() {
        return this.model.isEmpty();
    }

    @Override
    public Annotation addBookmark(int line) {
        LogEvent event;
        try {
            event = this.viewData.get(line);
            this.tagsModel.bookmark(event);
        }
        catch (Exception e) {
            return null;
        }
        Annotation a = this.annotations.add(AnnotationType.BOOKMARK, event, line);
        this.fireUpdate(LogModelEvent.ANNOTATED);
        return a;
    }

    @Override
    public Annotation addBookmark(LogEvent event) {
        this.tagsModel.bookmark(event);
        Annotation a = this.annotations.add(AnnotationType.BOOKMARK, event, this.viewData.indexOf(event));
        this.fireUpdate(LogModelEvent.ANNOTATED);
        return a;
    }

    @Override
    public void removeBookmark(LogEvent event) {
        if (event == null) {
            return;
        }
        this.tagsModel.unbookmark(event);
        this.annotations.remove(new Annotation(event, AnnotationType.BOOKMARK, this.viewData.indexOf(event)));
        this.fireUpdate(LogModelEvent.ANNOTATED);
    }

    @Override
    public void removeAnnotations(AnnotationType type) {
        this.annotations.clear(type);
        if (type == AnnotationType.BOOKMARK) {
            this.tagsModel.unbookmark(null);
        }
        this.fireUpdate(LogModelEvent.ANNOTATED);
    }

    @Override
    public void removeAnnotation(Collection<Annotation> collection) {
        for (Annotation a : collection) {
            this.annotations.remove(a);
            if (!a.isBookmark()) continue;
            this.tagsModel.unbookmark(a.getEvent());
        }
        this.fireUpdate(LogModelEvent.ANNOTATED);
    }

    @Override
    public Collection<Annotation> getAnnotations(AnnotationType type) {
        return this.annotations.getAnnotations(type);
    }

    @Override
    public List<Integer> getTagLocations() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Annotation annotation : this.getAnnotations(AnnotationType.TAG)) {
            list.add(annotation.getLocation());
        }
        return list;
    }

    @Override
    public int getSize() {
        return this.viewData.size();
    }

    @Override
    public TimePeriod getTimeRange() {
        if (this.model.isEmpty()) {
            return new SimpleTimePeriod(0L, 0L);
        }
        long first = this.model.get(0).getLoggerTimeStamp();
        long last = this.model.get(this.model.size() - 1).getLoggerTimeStamp();
        return new SimpleTimePeriod(first, last);
    }

    @Override
    public int getDrillEventIndex() {
        if (this.drillEvent == null) {
            return -1;
        }
        int i = 0;
        while (i < this.viewData.size()) {
            LogEvent event = this.viewData.get(i);
            if (this.drillEvent.getLoggerTimeStamp() == event.getLoggerTimeStamp()) {
                this.drillEvent.getMessage();
            }
            if (this.drillEvent.getLoggerTimeStamp() == event.getLoggerTimeStamp() && this.drillEvent.getMessage().equals(event.getMessage())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getIndexOf(LogEvent event) {
        return event != null ? this.viewData.indexOf(event) : -1;
    }

    @Override
    public int getIndexOfFirstBookmark() {
        Iterator<Annotation> iterator = this.getAnnotations(AnnotationType.BOOKMARK).iterator();
        if (iterator.hasNext()) {
            Annotation a = iterator.next();
            return this.getIndexOf(a.getEvent());
        }
        return -1;
    }

    @Override
    public List<LogEvent> getStorageData() {
        return this.model;
    }

    @Override
    public List<LogEvent> getViewData() {
        return this.viewData;
    }

    @Override
    public LogEvent getViewItem(int index) {
        if (index < 0 || index >= this.viewData.size()) {
            return null;
        }
        return this.viewData.get(index);
    }

    @Override
    public LogViewFilter getViewFilter() {
        return this.filter;
    }

    @Override
    public void setViewFilter(LogViewFilter filter) {
        this.filter = filter;
        this.annotations.clear();
        this.viewData.clear();
        for (LogEvent event : this.model) {
            if (!filter.pass((LogEvent)((LoggingEventVO)event))) continue;
            this.viewData.add(event);
            this.annotate(event, this.viewData.size() - 1);
        }
        this.fireUpdate(LogModelEvent.FILTERED);
    }

    @Override
    public void refresh() {
        this.setViewFilter(this.filter);
    }

    @Override
    public void revert() {
        final boolean desc = !this.isDescending();
        Object[] arr = this.model.toArray(new LogEvent[this.model.size()]);
        Arrays.sort(arr, new Comparator<LogEvent>(){

            @Override
            public int compare(LogEvent e1, LogEvent e2) {
                if (desc) {
                    return e1.getLoggerTimeStamp() - e2.getLoggerTimeStamp() < 0L ? 1 : -1;
                }
                return e1.getLoggerTimeStamp() - e2.getLoggerTimeStamp() < 0L ? -1 : 1;
            }
        });
        this.model = Lists.newArrayList((Object[])arr);
        this.refresh();
    }

    @Override
    public boolean isDescending() {
        if (this.model.isEmpty()) {
            return false;
        }
        return this.model.get(0).getLoggerTimeStamp() > this.model.get(this.model.size() - 1).getLoggerTimeStamp();
    }

    @Override
    public List<String> getOptions(int column) {
        if (column == 12) {
            return Lists.newArrayList();
        }
        if (column == 0) {
            ArrayList ret = Lists.newArrayList();
            for (LfsLevel level : LfsLevel.toList()) {
                ret.add(level.toString());
            }
            return ret;
        }
        TreeSet<String> ret = new TreeSet<String>();
        block10: for (LogEvent e : this.viewData) {
            LoggingEventVO event = (LoggingEventVO)e;
            switch (column) {
                case 5: {
                    ret.add(event.getDomainName());
                    break;
                }
                case 6: {
                    ret.add(this.components.getComponent(event));
                    break;
                }
                case 1: {
                    String tags = (String)event.getProperties().get("tags");
                    if (tags == null) continue block10;
                    String[] stringArray = StringUtils.tokenizeToStringArray(tags, ",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String tag = stringArray[n2];
                        ret.add(tag);
                        ++n2;
                    }
                    continue block10;
                }
                case 4: {
                    ret.add(event.getHostName());
                    break;
                }
                case 7: {
                    ret.add(event.getLoggerName());
                    break;
                }
                case 8: {
                    ret.add(event.getThreadName());
                    break;
                }
                case 10: {
                    String exception = event.getExceptionClass();
                    if (!StringUtils.hasText(exception)) continue block10;
                    ret.add(exception);
                    break;
                }
                default: {
                    String property;
                    String value;
                    if (!Columns.isMdcColumn(column) || !StringUtils.hasText(value = event.getProperty(property = Columns.column2mdc(column)))) continue block10;
                    ret.add(value);
                }
            }
        }
        return Lists.newArrayList(ret);
    }

    private boolean contains(String string, String text) {
        return string != null && string.toLowerCase().contains(text);
    }

    private boolean find(String text, LoggingEventVO event) {
        if (!StringUtils.hasText(text) || event == null) {
            return false;
        }
        text = text.toLowerCase();
        if (this.contains(event.getMessage(), text)) {
            return true;
        }
        Iterator iterator = MdcMap.getKeys().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            if (!this.contains(event.getProperty(MdcMap.getName((int)key)), text)) continue;
            return true;
        }
        if (this.contains(event.getThrowableInfo(), text)) {
            return true;
        }
        if (this.contains(event.getDomainName(), text)) {
            return true;
        }
        if (this.contains(event.getHostName(), text)) {
            return true;
        }
        if (this.contains(event.getLoggerName(), text)) {
            return true;
        }
        if (this.contains(event.getThreadName(), text)) {
            return true;
        }
        if (this.contains(event.getNdc(), text)) {
            return true;
        }
        if (this.contains(event.getLocClassName(), text)) {
            return true;
        }
        if (this.contains(event.getLocFileName(), text)) {
            return true;
        }
        return this.contains(event.getLocMethodName(), text);
    }

    @Override
    public int find(String text, int from, boolean forward) {
        if (from < 0) {
            from = 0;
        }
        int size = this.viewData.size();
        if (forward) {
            int i = from;
            while (i < size) {
                if (this.find(text, (LoggingEventVO)this.viewData.get(i))) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = from;
            while (i > 0) {
                if (this.find(text, (LoggingEventVO)this.viewData.get(i))) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    @Override
    public List<Annotation> findAndAnnotate(String text) {
        ArrayList bookmarks = Lists.newArrayList();
        int size = this.viewData.size();
        int i = 0;
        while (i < size) {
            int line = this.find(text, i, true);
            if (line == -1) break;
            bookmarks.add(this.addBookmark(line));
            i = line;
            ++i;
        }
        return bookmarks;
    }

    @Override
    public int findAndFilter(String text) {
        int count = 0;
        this.annotations.clear();
        this.viewData.clear();
        for (LogEvent e : this.model) {
            LoggingEventVO event = (LoggingEventVO)e;
            if (!this.filter.pass((LogEvent)event) || !this.find(text, event)) continue;
            this.viewData.add((LogEvent)event);
            this.annotate((LogEvent)event, this.viewData.size() - 1);
            ++count;
        }
        this.fireUpdate(LogModelEvent.FILTERED);
        return count;
    }

    @Override
    public EventStyle getStyle(LogEvent event) {
        if (this.drillEvent != null && this.drillEvent.getLoggerTimeStamp() == event.getLoggerTimeStamp() && this.drillEvent.getMessage().equals(event.getMessage())) {
            return this.styles.getBookmarkStyle(event);
        }
        if (this.tagsModel.isBookmark(event)) {
            return this.styles.getBookmarkStyle(event);
        }
        return this.styles.getStyle(event);
    }

    @Override
    public void addListener(LogModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(LogModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void fireUpdate(final LogModelEvent event) {
        for (final LogModelListener listener : this.listeners) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    listener.modelUpdated(event);
                }
            });
        }
    }

    @Override
    public LogEvent getDrillEvent() {
        return this.drillEvent;
    }

    @Override
    public void setDrillEvent(LogEvent event) {
        this.drillEvent = event;
    }

    @Override
    public void setAutoClear(boolean autoclear) {
        this.autoclear = autoclear;
        if (autoclear && this.model.size() > this.maxSize) {
            this.clear();
        }
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        int toremove = this.model.size() - maxSize;
        if (toremove > 0) {
            this.model.subList(0, toremove).clear();
            this.refresh();
        }
    }

    @Override
    public LogEvent getSelectedEvent() {
        return this.selectedEvent;
    }

    @Override
    public void setSelectedEvent(LogEvent selectedEvent) {
        this.selectedEvent = selectedEvent;
    }
}

