/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model.data;

import com.moonlit.logfaces.client.model.EventStyle;
import com.moonlit.logfaces.client.model.data.ColumnType;
import com.moonlit.logfaces.server.conf.MdcMap;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import org.eclipse.swt.widgets.TableItem;

public class Column {
    private ColumnType type;
    private int width;
    private int mdcNumber = -1;
    private int index;

    public Column(String name, int index, int width) {
        this.width = width;
        this.index = index;
    }

    public void populateTableItem(TableItem item, LogEvent evt, EventStyle style) {
        LoggingEventVO event = (LoggingEventVO)evt;
        switch (this.type) {
            case level: {
                item.setImage(this.index, style.getImage());
                item.setBackground(style.getBackground());
                item.setForeground(style.getForeground());
                break;
            }
            case mdc: {
                String value = event.getProperty(MdcMap.getName((int)this.mdcNumber));
                if (value == null) break;
                item.setText(this.index, value);
                break;
            }
        }
    }

    public String getName() {
        return "";
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isFilterable() {
        return false;
    }

    public boolean isMDC() {
        return this.mdcNumber >= 0;
    }

    public int getIndex() {
        return this.index;
    }

    public ColumnType getType() {
        return this.type;
    }
}

