/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model.data;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.dashboard.SliceInfo;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.client.model.data.LogDataProjection;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.vo.StatVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BaseProjection
implements LogDataProjection {
    protected SliceInfo slice;
    protected long fromTime;
    protected long toTime;
    protected long rate;
    protected TimeRange requestedRate;
    protected LogDataModel model;
    protected List<Map<String, StatVO>> results = Lists.newArrayList();

    public BaseProjection(LogDataModel model, SliceInfo slice, TimeRange requestedRate) {
        this.model = model;
        this.slice = slice;
        this.requestedRate = requestedRate;
    }

    protected void create() {
        List<LogEvent> data = this.model.getViewData();
        if (data.isEmpty()) {
            return;
        }
        this.fromTime = data.get(0).getLoggerTimeStamp();
        this.toTime = data.get(data.size() - 1).getLoggerTimeStamp();
        this.rate = this.requestedRate.getRangeAdjusted(this.toTime - this.fromTime, 100);
        this.adjustEdges();
        long time = this.fromTime;
        while (time <= this.toTime) {
            this.results.add(new TreeMap());
            time += this.rate;
        }
        for (LogEvent event : data) {
            this.project(event);
        }
    }

    @Override
    public List<StatVO> getProjection() {
        ArrayList ret = Lists.newArrayList();
        this.addEdge(ret, true);
        for (Map<String, StatVO> map : this.results) {
            StatVO stat;
            if (this.slice.getAttribute() == EventAttribute.loggerLevel) {
                for (LfsLevel level : LfsLevel.toList()) {
                    stat = map.get(level.toString());
                    if (stat == null) continue;
                    ret.add(stat);
                }
                continue;
            }
            for (String category : map.keySet()) {
                stat = map.get(category);
                if (stat == null) continue;
                ret.add(stat);
            }
        }
        this.addEdge(ret, false);
        return ret;
    }

    protected void adjustEdges() {
        long span = this.toTime - this.fromTime;
        if (span < 3600000L) {
            this.rate = 60000L;
            long delta = (3600000L - span) / 2L;
            this.fromTime -= delta;
            this.toTime += delta;
        }
    }

    protected void addEdge(List<StatVO> list, boolean left) {
        StatVO edge = new StatVO();
        edge.setT1(left ? this.fromTime : this.toTime - 1L);
        edge.setT2(left ? this.fromTime + 1L : this.toTime);
        edge.setCount(0.0f);
        edge.setProjection("");
        list.add(edge);
    }

    protected void project(LogEvent e) {
    }

    protected void increment(long time, String series) {
        if (series == null) {
            return;
        }
        StatVO bucket = this.getBucket(time, series);
        if (bucket != null) {
            bucket.increment();
        }
    }

    protected StatVO getBucket(long time, String series) {
        long index = (time - this.fromTime) / this.rate;
        if (index < 0L || index >= (long)this.results.size() || !StringUtils.hasText(series)) {
            return null;
        }
        Map<String, StatVO> map = this.results.get((int)index);
        StatVO stat = map.get(series);
        if (stat == null) {
            stat = new StatVO();
            stat.setT1(this.fromTime + index * this.rate);
            stat.setT2(this.fromTime + index * this.rate + this.rate);
            stat.setProjection(series);
            map.put(series, stat);
        }
        return stat;
    }
}

