/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model.data;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.model.data.Annotation;
import com.moonlit.logfaces.client.model.data.AnnotationType;
import com.moonlit.logfaces.server.core.LogEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AnnotationManager {
    private List<Annotation> levels = new CopyOnWriteArrayList<Annotation>();
    private List<Annotation> tags = new CopyOnWriteArrayList<Annotation>();
    private List<Annotation> books = new CopyOnWriteArrayList<Annotation>();

    public Annotation add(AnnotationType type, LogEvent event, int location) {
        Annotation annotation = new Annotation(event, type, location);
        this.getStore(type).add(annotation);
        return annotation;
    }

    public void remove(Annotation annotation) {
        this.getStore(annotation.getType()).remove(annotation);
    }

    public void clear() {
        this.levels.clear();
        this.tags.clear();
        this.books.clear();
    }

    public void clear(AnnotationType type) {
        this.getStore(type).clear();
    }

    public void trim(int positions) {
        this.trim(this.levels, positions);
        this.trim(this.tags, positions);
        this.trim(this.books, positions);
    }

    public void trim(List<Annotation> list, int positions) {
        ArrayList remove = Lists.newArrayList();
        for (Annotation a : list) {
            if (a.moveup(positions)) continue;
            remove.add(a);
        }
        list.removeAll(remove);
    }

    public Collection<Annotation> getAnnotations(AnnotationType type) {
        return this.getStore(type);
    }

    private List<Annotation> getStore(AnnotationType type) {
        switch (type) {
            case BOOKMARK: {
                return this.books;
            }
            case TAG: {
                return this.tags;
            }
        }
        return this.levels;
    }
}

