/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.server.util.Password;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.ui.IMemento;

public class UrlVO
implements Persistent {
    private String url = "";
    private String userName = "";
    private String password = "";
    private static Logger log = LogManager.getLogger(UrlVO.class);

    public UrlVO(String url) {
        this.url = url;
    }

    public UrlVO(IMemento memento) {
        this.load(memento);
    }

    public boolean equals(Object o) {
        if (o instanceof UrlVO) {
            UrlVO other = (UrlVO)o;
            return this.url.equals(other.url) && this.userName.equals(other.userName) && this.password.equals(other.password);
        }
        return false;
    }

    @Override
    public void load(IMemento memento) {
        try {
            this.url = memento.getString("url");
            this.userName = memento.getString("userName");
            this.password = Password.deobfuscate((String)memento.getString("password"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void save(IMemento memento) {
        try {
            IMemento root = memento.createChild("source");
            root.putString("url", this.url);
            root.putString("userName", this.userName);
            root.putString("password", Password.obfuscate((String)this.password));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName != null ? userName : "";
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password != null ? password : "";
    }

    public boolean isFile() {
        return !this.url.startsWith("http") && !this.url.startsWith("ftp");
    }

    public String forPath(String path) {
        if (!this.url.endsWith("/") && !path.startsWith("/")) {
            return this.url + "/" + path;
        }
        return this.url + path;
    }

    public boolean isProtected() {
        return this.userName != null && !this.userName.isEmpty();
    }

    public String encodeCredentials() {
        String auth = String.format("%s:%s", this.userName, this.password);
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.ISO_8859_1));
        return new String(encodedAuth);
    }

    public void resetCredentials() {
        this.userName = "";
        this.password = "";
    }
}

