/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.model.data.TagsModelListener;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;

public class TagsModel
extends ContextElement
implements Persistent {
    private List<TagsModelListener> listeners;
    private Set<Long> bookmarks;
    private Map<String, TagVO> tags = Maps.newTreeMap();
    private Set<String> dirty;
    private static TagsModel instance;

    public static TagsModel getInstance() {
        if (instance == null) {
            instance = new TagsModel();
        }
        return instance;
    }

    private TagsModel() {
        this.bookmarks = Sets.newHashSet();
        this.dirty = Sets.newHashSet();
        this.listeners = Lists.newArrayList();
    }

    public List<TagVO> getTags() {
        return Lists.newArrayList(this.tags.values());
    }

    public Map<String, CriteriaFilter> toCriteriaMap() {
        TreeMap map = Maps.newTreeMap();
        for (TagVO tag : this.tags.values()) {
            map.put(tag.getName(), tag.getCriteria());
        }
        return map;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public ContextElement getParent() {
        return null;
    }

    @Override
    public void fireContextChanged() {
        if (this.dirty.isEmpty()) {
            return;
        }
        for (TagsModelListener listener : this.listeners) {
            listener.handleTagsChange(this.dirty);
        }
        this.dirty.clear();
        Application.getPrefs().putLong("lfs_tags", System.currentTimeMillis());
    }

    public ContextElement[] getEntries() {
        return this.tags.values().toArray(new ContextElement[this.tags.size()]);
    }

    public TagVO create(String name) {
        TagVO tag = new TagVO();
        tag.setName(name);
        tag.setColor(Display.getCurrent().getSystemColor(6));
        tag.setCriteria((CriteriaFilter)new JexlCriteria());
        this.store(tag);
        return tag;
    }

    public void store(TagVO tag) {
        if (tag == null) {
            return;
        }
        tag.getCriteria().prepare();
        TagVO stored = this.tags.get(tag.getName());
        if (stored == null || stored != null && !stored.equals(tag)) {
            this.dirty.add(tag.getName());
        }
        this.tags.put(tag.getName(), tag);
    }

    public TagVO rename(String name, String newName) {
        this.dirty.add(name);
        this.dirty.add(newName);
        TagVO tag = this.tags.remove(name);
        if (tag != null) {
            tag.setName(newName);
            this.tags.put(newName, tag);
            return tag;
        }
        return null;
    }

    public TagVO get(String name) {
        if (name == null) {
            return null;
        }
        return this.tags.get(name);
    }

    public void replace(String name, TagVO tag) {
        this.dirty.add(name);
        this.dirty.add(tag.getName());
        this.tags.remove(name);
        tag.getCriteria().prepare();
        this.tags.put(tag.getName(), tag);
    }

    public TagVO remove(String name) {
        TagVO removed = this.tags.remove(name);
        this.dirty.add(name);
        return removed;
    }

    public void clear() {
        this.dirty.addAll(this.tags.keySet());
        this.tags.clear();
    }

    public int size() {
        return this.tags.size();
    }

    public boolean tag(LogEvent event) {
        Map props = event.getProperties();
        props.remove("tags");
        Object strtags = new String();
        for (TagVO tag : this.tags.values()) {
            if (!tag.isEnabled() || !tag.qualify(event)) continue;
            strtags = ((String)strtags).isEmpty() ? tag.getName() : (String)strtags + String.format(",%s", tag.getName());
        }
        if (!((String)strtags).isEmpty()) {
            props.put("tags", strtags);
        }
        return !((String)strtags).isEmpty();
    }

    public boolean untag(LogEvent event, Collection<String> tags) {
        String[] split;
        if (tags == null || tags.isEmpty()) {
            return false;
        }
        boolean removed = false;
        Map props = event.getProperties();
        String t = (String)props.get("tags");
        if (t == null || t.isEmpty()) {
            return false;
        }
        Object strtags = new String();
        String[] stringArray = split = StringUtils.tokenizeToStringArray(t, ",");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (tags.contains(tag)) {
                removed = true;
            } else {
                strtags = ((String)strtags).isEmpty() ? tag : (String)strtags + String.format(",%s", tag);
            }
            ++n2;
        }
        if (!((String)strtags).isEmpty()) {
            props.put("tags", strtags);
        } else {
            props.remove("tags");
        }
        return removed;
    }

    public boolean isTagged(LogEvent event) {
        String t = (String)event.getProperties().get("tags");
        return t != null && !t.isEmpty();
    }

    public void bookmark(LogEvent event) {
        if (event.getSequenceNumber() != 0L) {
            this.bookmarks.add(event.getSequenceNumber());
        }
    }

    public void unbookmark(LogEvent event) {
        if (event == null) {
            this.bookmarks.clear();
            return;
        }
        this.bookmarks.remove(event.getSequenceNumber());
    }

    public boolean isBookmark(LogEvent event) {
        return this.bookmarks.contains(event.getSequenceNumber());
    }

    public boolean hasBookmarks() {
        return !this.bookmarks.isEmpty();
    }

    public TagVO findOne(LogEvent event) {
        if (event == null) {
            return null;
        }
        String eventTags = (String)event.getProperties().get("tags");
        if (eventTags == null || eventTags.length() == 0) {
            return null;
        }
        String[] split = StringUtils.tokenizeToStringArray(eventTags, ",");
        if (split.length > 0) {
            return this.tags.get(split[0]);
        }
        return null;
    }

    public void addListener(TagsModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TagsModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void load(IMemento memento) {
        this.clear();
        IMemento root = memento.getChild("tags");
        if (root == null) {
            return;
        }
        IMemento[] iMementoArray = root.getChildren("tag");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento m = iMementoArray[n2];
            this.store(new TagVO(m));
            ++n2;
        }
    }

    @Override
    public void save(IMemento memento) {
        IMemento root = memento.createChild("tags");
        for (TagVO tag : this.tags.values()) {
            tag.save(root);
        }
    }
}

