/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IMemento;

public class TagVO
extends ContextElement
implements Comparable<TagVO>,
Cloneable,
Persistent {
    private String name;
    private Color color;
    private boolean enabled;
    private CriteriaFilter criteria;

    public TagVO() {
        this.name = "tag";
        this.color = new Color(null, 0, 80, 160);
        this.criteria = new JexlCriteria();
        this.enabled = true;
    }

    public TagVO(IMemento memento) {
        this.load(memento);
    }

    @Override
    public void load(IMemento memento) {
        try {
            this.name = memento.getString("name");
            String[] split = StringUtils.tokenizeToStringArray(memento.getString("color"), ",");
            this.color = new Color(null, Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
            this.enabled = memento.getBoolean("enabled") == null ? true : memento.getBoolean("enabled");
            this.criteria = Utils.unserializeCriteria(memento);
            this.criteria.prepare();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void save(IMemento memento) {
        IMemento root = memento.createChild("tag");
        root.putString("name", this.name);
        root.putBoolean("enabled", this.enabled);
        root.putString("color", String.format("%d,%d,%d", this.color.getRed(), this.color.getGreen(), this.color.getBlue()));
        Utils.serializeCriteria(root, this.criteria);
    }

    public TagVO clone() {
        TagVO clone = new TagVO();
        clone.setName(this.name);
        clone.setEnabled(this.enabled);
        clone.setColor(this.color);
        clone.setCriteria(this.criteria.clone());
        return clone;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TagVO)) {
            return false;
        }
        TagVO other = (TagVO)o;
        return this.name.equals(other.name) && this.enabled == other.enabled && this.color.equals((Object)other.color) && this.criteria.equals(other.criteria);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int compareTo(TagVO other) {
        if (other == null) {
            return -1;
        }
        return this.name.compareToIgnoreCase(other.name);
    }

    @Override
    public ContextElement getParent() {
        return TagsModel.getInstance();
    }

    @Override
    protected void fireContextChanged() {
    }

    public CriteriaFilter getCriteria() {
        return this.criteria;
    }

    public void setCriteria(CriteriaFilter criteria) {
        this.criteria = criteria == null ? new JexlCriteria() : criteria;
        this.criteria.prepare();
    }

    public boolean qualify(LogEvent event) {
        return this.criteria.qualify((Object)event);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

