/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.UrlVO;
import com.moonlit.logfaces.client.utils.StringUtils;
import java.net.PasswordAuthentication;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.IMemento;

public class SourceMappingModel
implements Persistent {
    private static SourceMappingModel instance;
    private List<UrlVO> dirs = Lists.newArrayList();
    private List<UrlVO> urls = Lists.newArrayList();
    private boolean dirty;
    private static Logger log;

    static {
        log = LogManager.getLogger(SourceMappingModel.class);
    }

    private SourceMappingModel() {
    }

    public static SourceMappingModel getInstance() {
        if (instance == null) {
            instance = new SourceMappingModel();
        }
        return instance;
    }

    @Override
    public void load(IMemento memento) {
        this.removeAll();
        IMemento root = memento.getChild("sources");
        if (root == null) {
            this.convert();
            return;
        }
        IMemento[] iMementoArray = root.getChildren("source");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento m = iMementoArray[n2];
            UrlVO vo = new UrlVO(m);
            if (vo.isFile()) {
                this.dirs.add(vo);
            } else {
                this.urls.add(vo);
            }
            ++n2;
        }
    }

    @Override
    public void save(IMemento memento) {
        IMemento root = memento.createChild("sources");
        for (UrlVO vo : this.dirs) {
            vo.save(root);
        }
        for (UrlVO vo : this.urls) {
            vo.save(root);
        }
    }

    public void removeAll() {
        this.dirs.clear();
        this.urls.clear();
    }

    public PasswordAuthentication findAuthentication(String url) {
        for (UrlVO vo : this.urls) {
            if (!url.startsWith(vo.getUrl()) || vo.getUserName().isEmpty() || vo.getPassword().isEmpty()) continue;
            return new PasswordAuthentication(vo.getUserName(), vo.getPassword().toCharArray());
        }
        return null;
    }

    private void convert() {
        try {
            String s;
            int n;
            int n2;
            String[] stringArray;
            String[] split;
            IEclipsePreferences prefs = Application.getPrefs();
            String temp = prefs.get("lfs_source_dirs", null);
            if (temp != null) {
                stringArray = split = StringUtils.tokenizeToStringArray(temp, ";");
                n2 = split.length;
                n = 0;
                while (n < n2) {
                    s = stringArray[n];
                    this.dirs.add(new UrlVO(s));
                    ++n;
                }
            }
            if ((temp = prefs.get("lfs_source_urls", null)) != null) {
                stringArray = split = StringUtils.tokenizeToStringArray(temp, ";");
                n2 = split.length;
                n = 0;
                while (n < n2) {
                    s = stringArray[n];
                    this.urls.add(new UrlVO(s));
                    ++n;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<UrlVO> getDirs() {
        return Lists.newArrayList(this.dirs);
    }

    public void setDirs(List<UrlVO> list) {
        this.checkDirty(this.dirs, list);
        this.dirs = list;
    }

    public List<UrlVO> getUrls() {
        return Lists.newArrayList(this.urls);
    }

    public void setUrls(List<UrlVO> list) {
        this.checkDirty(this.urls, list);
        this.urls = list;
    }

    private void checkDirty(List<UrlVO> list1, List<UrlVO> list2) {
        if (list1.size() != list2.size()) {
            this.dirty = true;
            return;
        }
        if (list1.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < list1.size()) {
            if (!list1.get(i).equals(list2.get(i))) {
                this.dirty = true;
                return;
            }
            ++i;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

