/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.moonlit.logfaces.client.model.UrlVO;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SourceIndexModel {
    private static SourceIndexModel instance;
    private List<File> index = Lists.newArrayList();
    private Map<String, UrlVO> urls = Maps.newHashMap();
    private static Logger log;

    static {
        log = LogManager.getLogger(SourceIndexModel.class);
    }

    private SourceIndexModel() {
    }

    public static SourceIndexModel getInstance() {
        if (instance == null) {
            instance = new SourceIndexModel();
        }
        return instance;
    }

    public void init(List<File> list) {
        this.index = list;
    }

    public List<File> getFiles(String fileName) {
        ArrayList<File> ret = new ArrayList<File>();
        if (fileName == null || fileName.length() == 0) {
            return ret;
        }
        File theFile = new File(fileName);
        for (File file : this.index) {
            try {
                if (!file.getName().equals(fileName) && !file.getName().equals(theFile.getName())) continue;
                ret.add(file);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return ret;
    }

    public void cacheLocation(String fileName, UrlVO location) {
        if (fileName != null && location != null) {
            this.urls.put(fileName, location);
        }
    }

    public void clearCache() {
        this.urls.clear();
    }

    public UrlVO getLocation(String fileName) {
        return this.urls.get(fileName);
    }
}

