/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.moonlit.logfaces.client.model.RepositoryElement;
import com.moonlit.logfaces.client.model.RepositoryLoggerModel;
import com.moonlit.logfaces.server.vo.RepositoryEntryVO;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeMap;

public class RepositoryPackageModel
extends RepositoryElement {
    private String name;
    private RepositoryElement parent;
    private TreeMap<String, RepositoryLoggerModel> loggers = new TreeMap();

    public String toString() {
        return this.name;
    }

    public RepositoryPackageModel(String name, RepositoryElement parent) {
        this.name = name;
        this.parent = parent;
    }

    @Override
    protected void fireContextChanged() {
        this.parent.fireContextChanged();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RepositoryElement getParent() {
        return this.parent;
    }

    @Override
    public void addEntry(RepositoryEntryVO entry) {
        String entryName = entry.getLoggerName();
        int index = entryName.lastIndexOf(46);
        String loggerName = entryName;
        if (index != -1) {
            loggerName = entryName.substring(index + 1);
        }
        if (!this.loggers.containsKey(loggerName)) {
            RepositoryLoggerModel loggerModel = new RepositoryLoggerModel(loggerName, this);
            loggerModel.addEntry(entry);
            this.loggers.put(loggerName, loggerModel);
            this.fireContextChanged();
        }
    }

    @Override
    public RepositoryElement[] getEntries() {
        return this.loggers.values().toArray(new RepositoryLoggerModel[this.loggers.size()]);
    }

    public String getDomainName() {
        return this.parent.getName();
    }

    public String[] getLoggerNames() {
        HashSet<String> names = new HashSet<String>();
        for (RepositoryLoggerModel logger : this.loggers.values()) {
            names.add(logger.getFullName());
        }
        return names.toArray(new String[names.size()]);
    }

    public Collection<RepositoryLoggerModel> getLoggers() {
        return this.loggers.values();
    }

    @Override
    public void deleteChild(RepositoryElement child) {
        this.loggers.values().remove(child);
    }

    @Override
    public void deleteMe() {
        this.loggers.clear();
        this.parent.deleteChild(this);
    }
}

