/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.moonlit.logfaces.client.model.ContextListener;
import com.moonlit.logfaces.client.model.RepositoryDomainModel;
import com.moonlit.logfaces.client.model.RepositoryElement;
import com.moonlit.logfaces.client.model.RepositoryHostsModel;
import com.moonlit.logfaces.client.model.RepositoryLoggerModel;
import com.moonlit.logfaces.client.model.RepositoryPackageModel;
import com.moonlit.logfaces.server.vo.RepositoryEntryVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.ListenerList;

public class RepositoryModel
extends RepositoryElement {
    private Map<String, RepositoryDomainModel> domains = new TreeMap<String, RepositoryDomainModel>();
    private RepositoryHostsModel hosts = new RepositoryHostsModel(this);
    private Set<String> exceptions = new TreeSet<String>();
    private ListenerList<ContextListener> listeners = new ListenerList();
    private boolean silent;
    private static Logger log = LogManager.getLogger(RepositoryModel.class);
    private static RepositoryModel instance;

    private RepositoryModel() {
    }

    public static RepositoryModel getInstance() {
        if (instance == null) {
            instance = new RepositoryModel();
        }
        return instance;
    }

    public RepositoryDomainModel[] getDomains() {
        if (this.domains != null) {
            return this.domains.values().toArray(new RepositoryDomainModel[this.domains.size()]);
        }
        return new RepositoryDomainModel[0];
    }

    public Collection<String> getDomainNames() {
        return new TreeSet<String>(this.domains.keySet());
    }

    public Set<RepositoryLoggerModel> getLoggers() {
        HashSet<RepositoryLoggerModel> ret = new HashSet<RepositoryLoggerModel>();
        for (RepositoryDomainModel domain : this.domains.values()) {
            ret.addAll(domain.getLoggers());
        }
        return ret;
    }

    public Set<RepositoryPackageModel> getPackages() {
        HashSet<RepositoryPackageModel> ret = new HashSet<RepositoryPackageModel>();
        for (RepositoryDomainModel domain : this.domains.values()) {
            ret.addAll(domain.getPackagesList());
        }
        return ret;
    }

    public Collection<String> getLoggerNames() {
        TreeSet<String> set = new TreeSet<String>();
        for (RepositoryLoggerModel logger : this.getLoggers()) {
            set.add(logger.getFullName());
        }
        return set;
    }

    public String[] getPackageNames() {
        Set<RepositoryPackageModel> packs = this.getPackages();
        TreeSet<String> set = new TreeSet<String>();
        for (RepositoryPackageModel pack : packs) {
            set.add(pack.getName());
        }
        return set.toArray(new String[set.size()]);
    }

    public RepositoryHostsModel getHosts() {
        return this.hosts;
    }

    public Collection<String> getHostNames() {
        return this.hosts.getHostNames();
    }

    public String[] getExceptions() {
        return this.exceptions.toArray(new String[this.exceptions.size()]);
    }

    public List<String> listExceptions() {
        return new ArrayList<String>(this.exceptions);
    }

    public Set<RepositoryEntryVO> getRepositoryData() {
        HashSet<RepositoryEntryVO> ret = new HashSet<RepositoryEntryVO>();
        for (RepositoryDomainModel domain : this.domains.values()) {
            for (RepositoryLoggerModel loggerModel : domain.getLoggers()) {
                ret.add(loggerModel.getRepositoryEntry());
            }
        }
        return ret;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public RepositoryElement getParent() {
        return null;
    }

    public void addContextListener(ContextListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeContextListener(ContextListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void fireContextChanged() {
        if (this.silent) {
            return;
        }
        Object[] rls = this.listeners.getListeners();
        int i = 0;
        while (i < rls.length) {
            ContextListener listener = (ContextListener)rls[i];
            listener.contextChanged();
            ++i;
        }
    }

    @Override
    public void addEntry(RepositoryEntryVO entry) {
        if (entry.isException()) {
            this.exceptions.add(entry.getLoggerName());
            return;
        }
        String domainName = entry.getDomainName();
        RepositoryDomainModel domainModel = this.domains.get(domainName);
        if (domainModel == null) {
            domainModel = new RepositoryDomainModel(domainName, this);
            this.domains.put(domainName, domainModel);
            this.fireContextChanged();
        }
        domainModel.addEntry(entry);
        this.hosts.addEntry(entry);
    }

    public void reload(List<RepositoryEntryVO> entries) {
        this.silent = true;
        this.domains.clear();
        this.hosts.clear();
        this.exceptions.clear();
        if (entries != null) {
            for (RepositoryEntryVO entry : entries) {
                if (entry.isException()) {
                    this.exceptions.add(entry.getLoggerName());
                    this.hosts.addEntry(entry);
                    continue;
                }
                String domainName = entry.getDomainName();
                RepositoryDomainModel domainModel = this.domains.get(domainName);
                if (domainModel == null) {
                    domainModel = new RepositoryDomainModel(domainName, this);
                    this.domains.put(domainName, domainModel);
                }
                domainModel.addEntry(entry);
                this.hosts.addEntry(entry);
            }
        }
        this.fireContextChanged();
        this.silent = false;
    }

    @Override
    public RepositoryElement[] getEntries() {
        return this.domains.values().toArray(new RepositoryDomainModel[this.domains.size()]);
    }

    public void clear() {
        this.domains.clear();
        this.hosts.clear();
        this.exceptions.clear();
        this.fireContextChanged();
    }

    @Override
    public void deleteChild(RepositoryElement child) {
        this.domains.values().remove(child);
    }

    @Override
    public void deleteMe() {
        this.domains.clear();
        this.hosts.clear();
        this.exceptions.clear();
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public void dump() {
        int loggers = 0;
        for (RepositoryDomainModel domain : this.domains.values()) {
            for (RepositoryPackageModel pack : domain.getPackagesList()) {
                loggers += pack.getLoggers().size();
            }
        }
        log.info(String.format("repository loggers: %d, hosts: %d", loggers, this.hosts.getEntries().length));
    }
}

