/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.moonlit.logfaces.client.model.RepositoryElement;
import com.moonlit.logfaces.server.vo.RepositoryEntryVO;

public class RepositoryLoggerModel
extends RepositoryElement {
    String name;
    String fullName;
    String domainName;
    RepositoryElement parent;
    RepositoryEntryVO repositoryEntry;

    public String toString() {
        return this.fullName;
    }

    public RepositoryLoggerModel(String name, RepositoryElement parent) {
        this.name = name;
        this.parent = parent;
    }

    @Override
    protected void fireContextChanged() {
        this.parent.fireContextChanged();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RepositoryElement getParent() {
        return this.parent;
    }

    @Override
    public void addEntry(RepositoryEntryVO entry) {
        this.repositoryEntry = entry;
        this.domainName = entry.getDomainName();
        this.fullName = entry.getLoggerName();
        this.fireContextChanged();
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getPackageName() {
        if (this.parent != null) {
            return this.parent.getName();
        }
        return "";
    }

    public String getFullName() {
        return this.fullName;
    }

    @Override
    public RepositoryElement[] getEntries() {
        return null;
    }

    public RepositoryEntryVO getRepositoryEntry() {
        return this.repositoryEntry;
    }

    @Override
    public void deleteChild(RepositoryElement child) {
    }

    @Override
    public void deleteMe() {
        this.parent.deleteChild(this);
    }
}

