/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.moonlit.logfaces.client.model.RepositoryElement;
import com.moonlit.logfaces.client.model.RepositoryHostModel;
import com.moonlit.logfaces.server.vo.RepositoryEntryVO;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;

public class RepositoryHostsModel
extends RepositoryElement {
    private Set<RepositoryHostModel> hosts = new TreeSet<RepositoryHostModel>();
    private RepositoryElement parent;

    public RepositoryHostsModel(RepositoryElement parent) {
        this.parent = parent;
    }

    public Collection<String> getHostNames() {
        TreeSet<String> ret = new TreeSet<String>();
        for (RepositoryHostModel host : this.hosts) {
            ret.add(host.getName());
        }
        return ret;
    }

    public void clear() {
        this.hosts.clear();
    }

    public void addHost(String host) {
        if ((host = host.trim()).length() == 0) {
            return;
        }
        if (this.hosts.add(new RepositoryHostModel(this, host))) {
            this.fireContextChanged();
        }
    }

    @Override
    public void addEntry(RepositoryEntryVO entry) {
        if (entry == null) {
            return;
        }
        String host = entry.getHostName().trim();
        if (host.length() == 0) {
            return;
        }
        if (this.hosts.add(new RepositoryHostModel(this, host))) {
            this.fireContextChanged();
        }
    }

    @Override
    public void deleteChild(RepositoryElement child) {
    }

    @Override
    public void deleteMe() {
    }

    @Override
    protected void fireContextChanged() {
        this.parent.fireContextChanged();
    }

    @Override
    public RepositoryElement[] getEntries() {
        return this.hosts.toArray(new RepositoryElement[this.hosts.size()]);
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public RepositoryElement getParent() {
        return this.parent;
    }
}

