/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.moonlit.logfaces.client.model.RepositoryElement;
import com.moonlit.logfaces.client.model.RepositoryLoggerModel;
import com.moonlit.logfaces.client.model.RepositoryPackageModel;
import com.moonlit.logfaces.server.vo.RepositoryEntryVO;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class RepositoryDomainModel
extends RepositoryElement {
    RepositoryElement parent;
    String name;
    TreeMap<String, RepositoryPackageModel> packages = new TreeMap();
    TreeMap<String, RepositoryLoggerModel> loggers = new TreeMap();

    public String toString() {
        return this.name;
    }

    public RepositoryDomainModel(String name, RepositoryElement parent) {
        this.name = name;
        this.parent = parent;
    }

    @Override
    protected void fireContextChanged() {
        this.parent.fireContextChanged();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RepositoryElement getParent() {
        return this.parent;
    }

    @Override
    public void addEntry(RepositoryEntryVO entry) {
        String entryName = entry.getLoggerName();
        if (!entryName.contains(".")) {
            RepositoryLoggerModel loggerModel = this.loggers.get(entryName);
            if (loggerModel == null) {
                int nofLoggers = this.loggers.size();
                loggerModel = new RepositoryLoggerModel(entryName, this);
                loggerModel.addEntry(entry);
                this.loggers.put(entryName, loggerModel);
                if (this.loggers.size() != nofLoggers) {
                    this.fireContextChanged();
                }
            }
            return;
        }
        int index = entryName.lastIndexOf(46);
        String packageName = entryName.substring(0, index);
        RepositoryPackageModel packageModel = this.packages.get(packageName);
        if (packageModel == null) {
            packageModel = new RepositoryPackageModel(packageName, this);
            this.packages.put(packageName, packageModel);
            this.fireContextChanged();
        }
        packageModel.addEntry(entry);
    }

    @Override
    public void deleteChild(RepositoryElement child) {
        if (child instanceof RepositoryPackageModel) {
            this.packages.values().remove(child);
        }
        if (child instanceof RepositoryLoggerModel) {
            this.loggers.values().remove(child);
        }
    }

    @Override
    public void deleteMe() {
        this.packages.clear();
        this.loggers.clear();
        this.parent.deleteChild(this);
    }

    @Override
    public RepositoryElement[] getEntries() {
        TreeSet<RepositoryElement> ret = new TreeSet<RepositoryElement>();
        ret.addAll(this.packages.values());
        ret.addAll(this.loggers.values());
        return ret.toArray(new RepositoryElement[ret.size()]);
    }

    public Collection<RepositoryLoggerModel> getLoggers() {
        HashSet<RepositoryLoggerModel> ret = new HashSet<RepositoryLoggerModel>();
        for (RepositoryPackageModel pack : this.packages.values()) {
            ret.addAll(pack.getLoggers());
        }
        ret.addAll(this.loggers.values());
        return ret;
    }

    public RepositoryPackageModel[] getPackages() {
        return this.packages.values().toArray(new RepositoryPackageModel[this.packages.size()]);
    }

    public Collection<RepositoryPackageModel> getPackagesList() {
        return this.packages.values();
    }
}

