/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.model.RepositoryDomainModel;
import com.moonlit.logfaces.client.model.RepositoryElement;
import com.moonlit.logfaces.client.model.RepositoryHostModel;
import com.moonlit.logfaces.client.model.RepositoryHostsModel;
import com.moonlit.logfaces.client.model.RepositoryLoggerModel;
import com.moonlit.logfaces.client.model.RepositoryModel;
import com.moonlit.logfaces.client.model.RepositoryPackageModel;
import com.moonlit.logfaces.client.utils.StringUtils;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RepositoryAdapterFactory
implements IAdapterFactory {
    private IWorkbenchAdapter rootAdapter = new IWorkbenchAdapter(){

        public Object getParent(Object o) {
            return null;
        }

        public String getLabel(Object o) {
            return "root";
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.moonlit.logfaces.client.plugin", (String)"icons/domain.gif");
        }

        public Object[] getChildren(Object o) {
            String filter = Application.getPrefs().get("REPO_DOMAIN_FILTER", "");
            if (!StringUtils.hasText(filter)) {
                return ((RepositoryModel)o).getEntries();
            }
            ArrayList<RepositoryDomainModel> list = new ArrayList<RepositoryDomainModel>();
            RepositoryDomainModel[] repositoryDomainModelArray = ((RepositoryModel)o).getDomains();
            int n = repositoryDomainModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                RepositoryDomainModel domain = repositoryDomainModelArray[n2];
                if (domain.match(filter)) {
                    list.add(domain);
                }
                ++n2;
            }
            return list.toArray(new RepositoryDomainModel[list.size()]);
        }
    };
    private IWorkbenchAdapter domainAdapter = new IWorkbenchAdapter(){

        public Object getParent(Object o) {
            return ((RepositoryDomainModel)o).getParent();
        }

        public String getLabel(Object o) {
            return ((RepositoryDomainModel)o).getName();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.moonlit.logfaces.client.plugin", (String)"icons/domain.gif");
        }

        public Object[] getChildren(Object o) {
            String filter = Application.getPrefs().get("REPO_PACKAGE_FILTER", "");
            if (!StringUtils.hasText(filter)) {
                return ((RepositoryDomainModel)o).getEntries();
            }
            ArrayList<RepositoryPackageModel> list = new ArrayList<RepositoryPackageModel>();
            RepositoryPackageModel[] repositoryPackageModelArray = ((RepositoryDomainModel)o).getPackages();
            int n = repositoryPackageModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                RepositoryPackageModel pack = repositoryPackageModelArray[n2];
                if (pack.match(filter)) {
                    list.add(pack);
                }
                ++n2;
            }
            return list.toArray(new RepositoryPackageModel[list.size()]);
        }
    };
    private IWorkbenchAdapter packageAdapter = new IWorkbenchAdapter(){

        public Object getParent(Object o) {
            return ((RepositoryPackageModel)o).getParent();
        }

        public String getLabel(Object o) {
            return ((RepositoryPackageModel)o).getName();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.moonlit.logfaces.client.plugin", (String)"/icons/package_obj.gif");
        }

        public Object[] getChildren(Object o) {
            return ((RepositoryPackageModel)o).getEntries();
        }
    };
    private IWorkbenchAdapter loggerAdapter = new IWorkbenchAdapter(){

        public Object getParent(Object o) {
            return ((RepositoryLoggerModel)o).getParent();
        }

        public String getLabel(Object o) {
            return ((RepositoryLoggerModel)o).getName();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.moonlit.logfaces.client.plugin", (String)"icons/class.gif");
        }

        public Object[] getChildren(Object o) {
            return new Object[0];
        }
    };
    private IWorkbenchAdapter hostsAdapter = new IWorkbenchAdapter(){

        public Object getParent(Object o) {
            return ((RepositoryHostsModel)o).getParent();
        }

        public String getLabel(Object o) {
            return "";
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public Object[] getChildren(Object o) {
            RepositoryHostsModel model = (RepositoryHostsModel)o;
            String filter = Application.getPrefs().get("HOST_FILTER", "");
            if (!StringUtils.hasText(filter)) {
                return model.getEntries();
            }
            ArrayList<RepositoryElement> list = new ArrayList<RepositoryElement>();
            RepositoryElement[] repositoryElementArray = model.getEntries();
            int n = repositoryElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                RepositoryElement host = repositoryElementArray[n2];
                if (host.match(filter)) {
                    list.add(host);
                }
                ++n2;
            }
            return list.toArray(new RepositoryElement[list.size()]);
        }
    };
    private IWorkbenchAdapter hostAdapter = new IWorkbenchAdapter(){

        public Object getParent(Object o) {
            return ((RepositoryHostModel)o).getParent();
        }

        public String getLabel(Object o) {
            return ((RepositoryHostModel)o).getName();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.moonlit.logfaces.client.plugin", (String)"icons/host.gif");
        }

        public Object[] getChildren(Object o) {
            return new Object[0];
        }
    };

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IWorkbenchAdapter.class && adaptableObject instanceof RepositoryModel) {
            return this.rootAdapter;
        }
        if (adapterType == IWorkbenchAdapter.class && adaptableObject instanceof RepositoryDomainModel) {
            return this.domainAdapter;
        }
        if (adapterType == IWorkbenchAdapter.class && adaptableObject instanceof RepositoryPackageModel) {
            return this.packageAdapter;
        }
        if (adapterType == IWorkbenchAdapter.class && adaptableObject instanceof RepositoryLoggerModel) {
            return this.loggerAdapter;
        }
        if (adapterType == IWorkbenchAdapter.class && adaptableObject instanceof RepositoryHostsModel) {
            return this.hostsAdapter;
        }
        if (adapterType == IWorkbenchAdapter.class && adaptableObject instanceof RepositoryHostModel) {
            return this.hostAdapter;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IWorkbenchAdapter.class};
    }
}

