/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.RegexModel;
import com.moonlit.logfaces.server.util.Patterns;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.ui.IMemento;

public class RegexVO
extends ContextElement
implements Comparable<RegexVO>,
Cloneable,
Persistent {
    private String name = "";
    private String expression = "";
    private String group = "";
    private boolean numeric;
    private Pattern pattern;

    public RegexVO() {
    }

    public RegexVO(String expression) {
        this.expression = expression;
    }

    public RegexVO(IMemento memento) {
        this.load(memento);
    }

    @Override
    public void load(IMemento memento) {
        try {
            this.name = memento.getString("name");
            this.expression = memento.getString("expression");
            this.numeric = memento.getBoolean("numeric");
            this.group = memento.getString("group");
            if (this.expression == null) {
                this.expression = "";
            }
            if (this.group == null) {
                this.group = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void save(IMemento memento) {
        IMemento root = memento.createChild("regex");
        root.putString("name", this.name != null ? this.name : "");
        root.putString("expression", this.expression != null ? this.expression : "");
        root.putString("group", this.group != null ? this.group : "");
        root.putBoolean("numeric", this.numeric);
    }

    public RegexVO clone() {
        RegexVO clone = new RegexVO();
        clone.setName(this.name);
        clone.setExpression(this.expression);
        clone.setGroup(this.group);
        clone.setNumeric(this.numeric);
        return clone;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RegexVO)) {
            return false;
        }
        RegexVO other = (RegexVO)o;
        return this.name.equals(other.name) && this.expression == other.expression && this.group.equals(other.group);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int compareTo(RegexVO other) {
        if (other == null) {
            return -1;
        }
        return this.name.compareToIgnoreCase(other.name);
    }

    @Override
    public ContextElement getParent() {
        return RegexModel.getInstance();
    }

    @Override
    protected void fireContextChanged() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.pattern = null;
    }

    public String getExpressionFor(String input) {
        Object temp = StringUtils.substringBetween((String)this.expression, (String)"%{", (String)(this.group + "}"));
        temp = "%{" + (String)temp + this.group + "}";
        return StringUtils.replace((String)this.expression, (String)temp, (String)input);
    }

    public void setName(String name) {
        this.name = name;
    }

    public Pattern getPattern() {
        return this.pattern != null ? this.pattern : Patterns.getInstance().buildPattern(this.expression);
    }

    public String extract(String input) {
        Matcher matcher;
        block4: {
            try {
                matcher = this.getPattern().matcher((CharSequence)input);
                if (matcher.find()) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (StringUtils.isBlank((CharSequence)this.group)) {
            return matcher.group(1);
        }
        return matcher.group(this.group);
    }

    public Map<String, String> extractAll(String input) {
        Matcher matcher;
        block4: {
            try {
                matcher = this.getPattern().matcher((CharSequence)input);
                if (matcher.find()) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        Map map = matcher.namedGroups();
        if (map.isEmpty()) {
            map.put("unnamed", matcher.group(1));
        }
        return map;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public void setNumeric(boolean numeric) {
        this.numeric = numeric;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String groupName) {
        this.group = groupName;
    }
}

