/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.RegexVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.ui.IMemento;

public class RegexModel
extends ContextElement
implements Persistent {
    private Map<String, RegexVO> store = new TreeMap<String, RegexVO>();
    private static RegexModel instance;

    public static RegexModel getInstance() {
        if (instance == null) {
            instance = new RegexModel();
        }
        return instance;
    }

    private RegexModel() {
    }

    public List<RegexVO> getRegexes() {
        return new ArrayList<RegexVO>(this.store.values());
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public ContextElement getParent() {
        return null;
    }

    @Override
    public void fireContextChanged() {
        Application.getPrefs().putLong("lfs_regex", System.currentTimeMillis());
    }

    public ContextElement[] getEntries() {
        return this.store.values().toArray(new ContextElement[this.store.size()]);
    }

    public RegexVO create(String name) {
        RegexVO regex = new RegexVO();
        regex.setName(name);
        this.store(regex);
        return regex;
    }

    public void store(RegexVO regex) {
        if (regex != null) {
            this.store.put(regex.getName(), regex);
        }
    }

    public RegexVO rename(String name, String newName) {
        RegexVO regex = this.store.remove(name);
        if (regex != null) {
            regex.setName(newName);
            this.store.put(newName, regex);
            return regex;
        }
        return null;
    }

    public RegexVO get(String name) {
        if (name == null) {
            return null;
        }
        return this.store.get(name);
    }

    public RegexVO remove(String name) {
        return this.store.remove(name);
    }

    public void clear() {
        this.store.clear();
    }

    public int size() {
        return this.store.size();
    }

    public List<String> getOptions(String what) {
        TreeSet set = Sets.newTreeSet();
        try {
            for (RegexVO regex : this.store.values()) {
                if (!"pattern".equalsIgnoreCase(what)) continue;
                set.add(regex.getExpression());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Lists.newArrayList((Iterable)set);
    }

    @Override
    public void load(IMemento memento) {
        this.clear();
        IMemento root = memento.getChild("expressions");
        if (root == null) {
            return;
        }
        IMemento[] iMementoArray = root.getChildren("regex");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento m = iMementoArray[n2];
            this.store(new RegexVO(m));
            ++n2;
        }
    }

    @Override
    public void save(IMemento memento) {
        IMemento root = memento.createChild("expressions");
        for (RegexVO regex : this.store.values()) {
            regex.save(root);
        }
    }
}

