/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.Columns;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.LogHeaderInfoVO;
import com.moonlit.logfaces.client.model.QueryModel;
import com.moonlit.logfaces.client.types.Direction;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.core.Order;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.criteria.Rule;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class QueryVO
extends ContextElement
implements Cloneable,
Persistent {
    private String name = "";
    private LogHeaderInfoVO[] headers;
    private TimeRange range = TimeRange.BEFORE_1_HOUR;
    private Order order = Order.ASCENDING;
    private boolean fetchThrowable = true;
    private boolean escapeSql;
    private long fromTime = Long.MIN_VALUE;
    private long toTime = Long.MAX_VALUE;
    private int limit = 1000;
    private TimeZone timeZone;
    private CriteriaFilter criteria;
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private SimpleDateFormat timeFormatShort = new SimpleDateFormat("HH:mm");
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy");
    private String pinID;
    private List<Long> pinMarks;

    public QueryVO() {
        this.setTimeZone(TimeZone.getDefault());
        this.setCriteria((CriteriaFilter)new JexlCriteria());
        this.headers = Columns.makeDefaultHeaders();
    }

    public QueryVO(String name) {
        this.name = name;
        this.setTimeZone(TimeZone.getDefault());
        this.setCriteria((CriteriaFilter)new JexlCriteria());
        this.headers = Columns.makeDefaultHeaders();
    }

    public QueryVO(String name, CriteriaFilter criteria) {
        this.name = name;
        this.setCriteria(criteria);
        this.setTimeZone(TimeZone.getDefault());
        this.headers = Columns.makeDefaultHeaders();
    }

    public QueryVO(String name, int limit, long from, long until) {
        this.name = name;
        this.limit = limit;
        this.fromTime = from;
        this.toTime = until;
        this.range = TimeRange.CUSTOM_RANGE;
        this.setTimeZone(TimeZone.getDefault());
        this.setCriteria((CriteriaFilter)new JexlCriteria());
        this.headers = Columns.makeDefaultHeaders();
    }

    public QueryVO(Map<String, Object> params) {
        this.setName((String)params.getOrDefault("name", "my query"));
        this.setFromTime((Long)params.getOrDefault("fromTime", 0L));
        this.setToTime((Long)params.getOrDefault("toTime", 0L));
        this.setOrder((Order)params.getOrDefault("order", Order.ASCENDING));
        this.setFetchThrowable((Boolean)params.getOrDefault("fetchThrowable", false));
        this.setEscapeSql((Boolean)params.getOrDefault("escapeSql", false));
        this.setLimit((Integer)params.getOrDefault("limit", -1));
        this.setCriteria((CriteriaFilter)params.get("criteria"));
        this.setTimeZone(TimeZone.getDefault());
        this.setHeaders(Columns.makeDefaultHeaders());
        this.setTimeRange(TimeRange.CUSTOM_RANGE, this.fromTime, this.fromTime);
        if (params.containsKey("pinID")) {
            this.setPinID(params.get("pinID").toString());
        }
        if (params.containsKey("pinMarks")) {
            this.pinMarks = (List)params.get("pinMarks");
        }
    }

    public void reset() {
        this.setTimeRange(TimeRange.BEFORE_1_HOUR, 0L, 0L);
        this.setTimeZone(TimeZone.getDefault());
        this.order = Order.ASCENDING;
        this.fetchThrowable = false;
        this.escapeSql = false;
        this.limit = 100;
        this.criteria = new JexlCriteria();
    }

    public QueryVO clone() {
        QueryVO ret = new QueryVO();
        ret.escapeSql = this.escapeSql;
        ret.name = this.name;
        ret.setTimeZone(this.timeZone);
        ret.setOrder(this.order);
        ret.setFetchThrowable(this.fetchThrowable);
        ret.setFromTime(this.fromTime);
        ret.setToTime(this.toTime);
        ret.setTimeRange(this.getRange(), this.getFromTime(), this.getToTime());
        ret.setLimit(this.limit);
        ret.setCriteria(this.criteria.clone());
        ret.headers = this.headers;
        ret.pinID = this.pinID;
        if (this.pinMarks != null) {
            ret.pinMarks = Lists.newArrayList(this.pinMarks);
        }
        return ret;
    }

    public void copy(QueryVO other) {
        this.escapeSql = other.escapeSql;
        this.name = other.name;
        this.setTimeZone(other.timeZone);
        this.setOrder(other.order);
        this.setFetchThrowable(other.fetchThrowable);
        this.setFromTime(other.fromTime);
        this.setToTime(other.toTime);
        this.setTimeRange(other.getRange(), other.getFromTime(), other.getToTime());
        this.setLimit(other.limit);
        this.setCriteria(other.criteria.clone());
        this.headers = other.headers;
        this.pinID = other.pinID;
        if (this.pinMarks != null) {
            this.pinMarks = Lists.newArrayList(other.pinMarks);
        }
    }

    public QueryVO(IMemento memento) {
        this.load(memento);
    }

    @Override
    public void load(IMemento memento) {
        Integer temp;
        this.name = memento.getString("name");
        this.headers = Columns.makeDefaultHeaders();
        if (memento.getInteger("descendingOrder") != null) {
            Order order = this.order = memento.getInteger("descendingOrder") == 1 ? Order.DESCENDING : Order.ASCENDING;
        }
        if (memento.getInteger("order") != null) {
            this.order = Order.values()[memento.getInteger("order")];
        }
        if (memento.getInteger("fetchThrowable") != null) {
            boolean bl = this.fetchThrowable = memento.getInteger("fetchThrowable") == 1;
        }
        if (memento.getInteger("escapeSql") != null) {
            boolean bl = this.escapeSql = memento.getInteger("escapeSql") == 1;
        }
        if ((temp = memento.getInteger("timeRangeType")) != null) {
            this.range = TimeRange.fromLegacy(temp);
        }
        if ((temp = memento.getInteger("timeRange")) != null) {
            this.range = TimeRange.fromInteger(temp);
        }
        if (memento.getString("fromTime") != null) {
            this.fromTime = Long.parseLong(memento.getString("fromTime"));
        }
        if (memento.getString("toTime") != null) {
            this.toTime = Long.parseLong(memento.getString("toTime"));
        }
        TimeZone tz = TimeZone.getDefault();
        String tzid = memento.getString("timezone");
        if (tzid != null) {
            tz = TimeZone.getTimeZone(tzid);
        }
        this.setTimeZone(tz);
        if (memento.getInteger("size") != null) {
            this.limit = memento.getInteger("size");
        }
        if (memento.getInteger("limit") != null) {
            this.limit = memento.getInteger("limit");
        }
        try {
            this.pinID = memento.getString("pinID");
            if (this.pinID != null) {
                this.pinMarks = Lists.newArrayList();
            }
            String[] stringArray = StringUtils.split((String)memento.getString("pinMarks"), (String)",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                this.pinMarks.add(Long.valueOf(string));
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.headers = Utils.unserializeHeaders(memento);
        this.criteria = Utils.unserializeCriteria(memento);
    }

    @Override
    public void save(IMemento parent) {
        try {
            IMemento memento = parent.getType().equals("query") ? parent : parent.createChild("query");
            memento.putString("name", this.name);
            memento.putString("timezone", this.timeZone.getID());
            memento.putInteger("timeRange", this.range.ordinal());
            memento.putString("fromTime", Long.toString(this.getFromTime()));
            memento.putString("toTime", Long.toString(this.getToTime()));
            memento.putInteger("order", this.order.ordinal());
            memento.putInteger("fetchThrowable", this.fetchThrowable ? 1 : 0);
            memento.putInteger("escapeSql", this.escapeSql ? 1 : 0);
            memento.putInteger("limit", this.limit);
            if (this.isPin()) {
                memento.putString("pinID", this.pinID);
                memento.putString("pinMarks", StringUtils.join(this.pinMarks, (String)","));
            }
            Utils.serializeHeaders(this.headers, memento);
            Utils.serializeCriteria(memento, this.criteria);
        }
        catch (Exception e) {
            Utils.complain("Failed to serialize query: " + this.name, e);
        }
    }

    public static QueryVO fromCommandLine(Map<String, String> params) {
        QueryVO vo = new QueryVO();
        String value = params.get("name");
        vo.setName(value != null ? value : "query");
        try {
            vo.setLimit(Integer.parseInt(params.get("limit")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            vo.setFromTime(Long.parseLong(params.get("fromTime")));
        }
        catch (NumberFormatException e) {
            vo.setFromTime(System.currentTimeMillis() - 28800000L);
        }
        try {
            vo.setToTime(Long.parseLong(params.get("toTime")));
        }
        catch (NumberFormatException e) {
            vo.setFromTime(System.currentTimeMillis());
        }
        vo.setTimeRange(TimeRange.CUSTOM_RANGE, vo.fromTime, vo.toTime);
        try {
            vo.setTimeZone(TimeZone.getTimeZone(params.get("timezone")));
        }
        catch (Exception e) {
            // empty catch block
        }
        Rule rule = vo.criteria.addRule();
        try {
            int level = Integer.parseInt(params.get("level"));
            rule.addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)LfsLevel.toLevel((int)level).name());
        }
        catch (Exception level) {
            // empty catch block
        }
        try {
            if (Boolean.parseBoolean(params.get("onlyThrown"))) {
                rule.addCondition((Object)EventAttribute.thrown, (Object)Operation.is, (Object)Boolean.TRUE.toString());
            }
        }
        catch (Exception level) {
            // empty catch block
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)params.get("matchMessage"))) {
                rule.addCondition((Object)EventAttribute.message, (Object)Operation.contains, (Object)params.get("matchMessage"));
            }
        }
        catch (Exception level) {
            // empty catch block
        }
        if ((value = params.get("domains")) != null) {
            String[] values = StringUtils.split((String)value, (String)",");
            Utils.addArrayCondition(rule, EventAttribute.domainName, values);
        }
        if ((value = params.get("loggers")) != null) {
            String[] values = StringUtils.split((String)value, (String)",");
            Utils.addArrayCondition(rule, EventAttribute.loggerName, values);
        }
        if ((value = params.get("hosts")) != null) {
            String[] values = StringUtils.split((String)value, (String)",");
            Utils.addArrayCondition(rule, EventAttribute.hostName, values);
        }
        if ((value = params.get("exception")) != null) {
            String[] values = StringUtils.split((String)value, (String)",");
            Utils.addArrayCondition(rule, EventAttribute.throwableInfo, values);
        }
        return vo;
    }

    public static QueryVO load(File file) throws Exception {
        XMLMemento root = XMLMemento.createReadRoot((Reader)new FileReader(file));
        if (root == null) {
            throw new Exception("Format is not acceptable");
        }
        return new QueryVO((IMemento)root);
    }

    public void save(File file) throws Exception {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"query");
        this.save((IMemento)memento);
        memento.save((Writer)new FileWriter(file));
    }

    public String toXml() throws Exception {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"query");
        this.save((IMemento)memento);
        StringWriter writer = new StringWriter();
        memento.save((Writer)writer);
        return ((Object)writer).toString();
    }

    public static QueryVO fromXml(String xml) throws Exception {
        XMLMemento root = XMLMemento.createReadRoot((Reader)new StringReader(xml));
        if (root == null) {
            throw new Exception("Format is not acceptable");
        }
        return new QueryVO((IMemento)root);
    }

    public Map<String, Object> toMap() {
        TreeMap<String, Object> ret = new TreeMap<String, Object>();
        ret.put("fromTime", this.getFromTime());
        ret.put("toTime", this.getToTime());
        ret.put("order", this.order);
        ret.put("fetchThrowable", this.fetchThrowable);
        ret.put("escapeSql", this.escapeSql);
        ret.put("limit", this.limit);
        ret.put("criteria", this.criteria);
        if (this.pinID != null) {
            ret.put("pinID", this.pinID);
        }
        if (this.pinMarks != null) {
            ret.put("pinMarks", this.pinMarks);
        }
        return ret;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ContextElement getParent() {
        return QueryModel.getInstance();
    }

    @Override
    protected void fireContextChanged() {
    }

    public void setName(String name) {
        this.name = name;
    }

    public void page(Direction direction) {
        long span = (this.getToTime() - this.getFromTime()) * (long)direction.toMultiplier();
        this.fromTime += span;
        this.toTime += span;
        this.range = TimeRange.CUSTOM_RANGE;
    }

    public long getFromTime() {
        switch (this.range) {
            case PARTICULAR_DAY: 
            case CUSTOM_RANGE: {
                return this.fromTime;
            }
            case ALL: {
                return Long.MIN_VALUE;
            }
        }
        return this.range.getTime(true, System.currentTimeMillis());
    }

    public void setFromTime(long fromTime) {
        this.fromTime = fromTime;
    }

    public long getToTime() {
        switch (this.range) {
            case PARTICULAR_DAY: 
            case CUSTOM_RANGE: {
                return this.toTime;
            }
            case ALL: {
                return Long.MAX_VALUE;
            }
        }
        return this.range.getTime(false, System.currentTimeMillis());
    }

    public void setToTime(long toTime) {
        this.toTime = toTime;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public void setTimeRange(TimeRange timeRange, long from, long until) {
        this.range = timeRange;
        switch (this.range) {
            case PARTICULAR_DAY: 
            case CUSTOM_RANGE: {
                this.fromTime = from;
                this.toTime = until;
                break;
            }
            case ALL: {
                this.fromTime = Long.MIN_VALUE;
                this.toTime = Long.MAX_VALUE;
                break;
            }
            default: {
                this.fromTime = this.range.getTime(true, System.currentTimeMillis());
                this.toTime = this.range.getTime(false, System.currentTimeMillis());
            }
        }
    }

    public TimeRange getRange() {
        return this.range;
    }

    public String toString() {
        return String.format("query [%s] from %s until %s", this.name, this.getFromDateTimeStamp(), this.getToDateTimeStamp());
    }

    public String getDateStamp(long time) {
        return this.dateFormat.format(new Date(time));
    }

    public String getTimeStamp(long time) {
        return this.timeFormat.format(new Date(time));
    }

    public String getTimeStampShort(long time) {
        return this.timeFormatShort.format(new Date(time));
    }

    public String getFromDateTimeStamp() {
        return this.getDateStamp(this.getFromTime()) + " " + this.getTimeStampShort(this.getFromTime());
    }

    public String getToDateTimeStamp() {
        return this.getDateStamp(this.getToTime()) + " " + this.getTimeStampShort(this.getToTime());
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.timeFormat.setTimeZone(timeZone);
        this.timeFormatShort.setTimeZone(timeZone);
        this.dateFormat.setTimeZone(timeZone);
    }

    public SimpleDateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public CriteriaFilter getCriteria() {
        return this.criteria;
    }

    public void setCriteria(CriteriaFilter criteria) {
        this.criteria = criteria;
    }

    public LogHeaderInfoVO[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(LogHeaderInfoVO[] headers) {
        if (headers != null) {
            this.headers = headers;
        }
    }

    public boolean isPin() {
        return this.pinID != null;
    }

    public void setPinID(String pid) {
        this.pinID = pid;
    }

    public String getPinID() {
        return this.pinID;
    }

    public void addPinMark(long sequence) {
        if (this.pinMarks == null) {
            this.pinMarks = Lists.newArrayList();
        }
        this.pinMarks.add(sequence);
    }

    public boolean isPinned(long sequence) {
        return this.pinMarks == null ? false : this.pinMarks.contains(sequence);
    }

    public long getFirstPinMark() {
        return this.pinMarks == null || this.pinMarks.isEmpty() ? -1L : this.pinMarks.get(0);
    }

    public boolean isFetchThrowable() {
        return this.fetchThrowable;
    }

    public void setFetchThrowable(boolean fetchThrowable) {
        this.fetchThrowable = fetchThrowable;
    }

    public boolean isEscapeSql() {
        return this.escapeSql;
    }

    public void setEscapeSql(boolean escapeSql) {
        this.escapeSql = escapeSql;
    }
}

