/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.jobs.FetchPinsJob;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.ContextListener;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.server.util.LfsEventBus;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ui.IMemento;

public class QueryModel
extends ContextElement
implements Persistent {
    private ListenerList<ContextListener> listeners;
    private static QueryModel instance;
    private List<QueryVO> queries = Lists.newArrayList();
    private Comparator<QueryVO> comparator;

    private QueryModel() {
        this.listeners = new ListenerList();
        this.comparator = new ThisComparator();
        LfsEventBus.getInstance().register((Object)this);
        FetchPinsJob job = new FetchPinsJob(false);
        job.setUser(true);
        job.schedule();
    }

    public static synchronized QueryModel getInstance() {
        if (instance == null) {
            instance = new QueryModel();
        }
        return instance;
    }

    @Override
    public String getName() {
        return "root";
    }

    @Subscribe
    public void handleLfcEvent(LfcEvent event) {
        if (event.is(LfcEvent.TYPE.PINS) || event.is(LfcEvent.TYPE.CONNECTED)) {
            for (QueryVO query : Lists.newArrayList(this.queries)) {
                if (!query.isPin()) continue;
                this.removeQuery(query.getName());
            }
            FetchPinsJob job = new FetchPinsJob(event.is(LfcEvent.TYPE.PINS));
            job.setUser(true);
            job.schedule(100L);
        }
    }

    @Override
    public ContextElement getParent() {
        return null;
    }

    public ContextElement[] getEntries() {
        Collections.sort(this.queries, this.comparator);
        if (this.queries != null) {
            return this.queries.toArray(new ContextElement[this.queries.size()]);
        }
        return new ContextElement[0];
    }

    public QueryVO getQuery(String name) {
        for (QueryVO query : this.queries) {
            if (!query.getName().equalsIgnoreCase(name)) continue;
            return query;
        }
        return null;
    }

    public boolean addQuery(QueryVO query) {
        if (query == null) {
            return false;
        }
        QueryVO removed = this.removeQuery(query.getName());
        this.queries.add(query);
        this.fireContextChanged();
        return removed != null;
    }

    public int getQueryIndex(String name) {
        if (name == null) {
            return 0;
        }
        int i = 0;
        Collections.sort(this.queries, this.comparator);
        for (QueryVO query : this.queries) {
            if (query.getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public QueryVO removeQuery(String name) {
        for (QueryVO query : Lists.newArrayList(this.queries)) {
            if (!query.getName().equalsIgnoreCase(name)) continue;
            this.queries.remove(query);
            this.fireContextChanged();
            return query;
        }
        return null;
    }

    public void removeAll() {
        this.queries.clear();
        this.fireContextChanged();
    }

    public int getNofPins() {
        int count = 0;
        for (QueryVO query : this.queries) {
            if (!query.isPin()) continue;
            ++count;
        }
        return count;
    }

    public void addContextListener(ContextListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeContextListener(ContextListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    protected void fireContextChanged() {
        Object[] rls = this.listeners.getListeners();
        int i = 0;
        while (i < rls.length) {
            ContextListener listener = (ContextListener)rls[i];
            listener.contextChanged();
            ++i;
        }
    }

    @Override
    public void load(IMemento memento) {
        this.removeAll();
        IMemento root = memento.getChild("queries");
        if (root == null) {
            return;
        }
        IMemento[] iMementoArray = root.getChildren("query");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento m = iMementoArray[n2];
            this.addQuery(new QueryVO(m));
            ++n2;
        }
    }

    @Override
    public void save(IMemento memento) {
        IMemento root = memento.createChild("queries");
        for (QueryVO query : this.queries) {
            if (query.isPin()) continue;
            query.save(root);
        }
    }

    class ThisComparator
    implements Comparator<QueryVO> {
        ThisComparator() {
        }

        @Override
        public int compare(QueryVO o1, QueryVO o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

