/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.jobs.SyncPluginsJob;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.PluginVO;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.server.core.LogFacesPlugin;
import com.moonlit.logfaces.server.plugins.PluginHolder;
import com.moonlit.logfaces.server.plugins.PluginsManager;
import com.moonlit.logfaces.server.util.LfsEventBus;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IMemento;

public class PluginsDelegate
extends ContextElement
implements Persistent {
    private static PluginsDelegate instance;
    private PluginsManager pm;
    private Map<String, PluginVO> plugins;
    private String ROOT_DIR = "com.moonlit.logfaces.plugins";
    private static Logger log;

    static {
        log = LogManager.getLogger(PluginsDelegate.class);
    }

    public static PluginsDelegate getInstance() {
        if (instance == null) {
            instance = new PluginsDelegate();
        }
        return instance;
    }

    private PluginsDelegate() {
        LfsEventBus.getInstance().register((Object)this);
        this.plugins = Maps.newTreeMap();
        this.pm = PluginsManager.getInstance();
    }

    @Override
    public void load(IMemento memento) {
        this.plugins = Maps.newTreeMap();
        IMemento root = memento.getChild("plugins");
        if (root != null) {
            IMemento[] iMementoArray = root.getChildren("plugin");
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento m = iMementoArray[n2];
                this.store(new PluginVO(m));
                ++n2;
            }
        }
        this.init();
    }

    @Override
    public void save(IMemento memento) {
        IMemento root = memento.createChild("plugins");
        for (PluginVO plugin : this.plugins.values()) {
            plugin.save(root);
        }
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public ContextElement getParent() {
        return null;
    }

    @Override
    protected void fireContextChanged() {
    }

    @Subscribe
    public void handleLfcEvent(LfcEvent event) {
        switch (event.getType()) {
            case CONNECTED: {
                break;
            }
            case WORKSPACE_LOADED: {
                break;
            }
            case WORKSPACE_REMOVED: {
                String name = event.getContext().toString();
                File dir = this.getHome(name);
                FileUtils.deleteQuietly((File)dir);
                break;
            }
        }
    }

    public List<PluginVO> getWorkspacePlugins() {
        return Lists.newArrayList(this.plugins.values());
    }

    public List<String> getWorkspacePluginNames() {
        ArrayList list = Lists.newArrayList();
        for (PluginVO pvo : this.plugins.values()) {
            list.add(pvo.getName());
        }
        return list;
    }

    public int importPlugins(File archive) throws Exception {
        int imported = this.pm.importPlugins(archive, this.getHome());
        this.plugins.clear();
        for (PluginHolder holder : this.pm.getPlugins()) {
            this.store(new PluginVO(holder));
        }
        return imported;
    }

    public LogFacesPlugin addPlugin(List<File> files) throws Exception {
        LogFacesPlugin plugin = this.pm.addPlugin(files);
        this.store(new PluginVO(this.pm.getPlugin(plugin.getName())));
        return plugin;
    }

    public List<PluginHolder> getPlugins() {
        return this.pm.getPlugins();
    }

    public boolean hasPlugin(String name) {
        return this.pm.getPlugin(name) != null;
    }

    public LogFacesPlugin getPlugin(String name) {
        PluginHolder holder = this.pm.getPlugin(name);
        return holder != null ? holder.getPlugin() : null;
    }

    public void store(PluginVO plugin) {
        this.plugins.put(plugin.getName(), plugin);
    }

    public void remove(PluginVO plugin) {
        this.plugins.remove(plugin.getName());
        PluginHolder holder = this.pm.getPlugin(plugin.getName());
        if (holder != null) {
            this.pm.removePlugin(holder.getID());
        }
    }

    private File getHome() {
        return this.getHome(WorkspaceHolder.getInstance().getCurrentWorkspace().getName());
    }

    private File getHome(String wsName) {
        String home = String.format("%s%s%s%s%s", Platform.getConfigurationLocation().getURL().getPath(), File.separator, this.ROOT_DIR, File.separator, wsName);
        return new File(home);
    }

    private void init() {
        try {
            if (this.pm.isInitialized()) {
                this.pm.terminate();
            }
            File home = this.getHome();
            this.pm.initialize(home.getCanonicalPath());
            this.synchronize();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void synchronize() {
        boolean reload = false;
        if (this.plugins.size() == this.pm.getPlugins().size()) {
            for (PluginVO pvo : this.plugins.values()) {
                if (this.pm.getPlugin(pvo.getName()) != null) continue;
                reload = true;
                break;
            }
            if (!reload) {
                return;
            }
        }
        this.pm.removeAllPlugins();
        SyncPluginsJob job = new SyncPluginsJob(Lists.newArrayList(this.plugins.keySet()));
        this.plugins.clear();
        job.setUser(false);
        job.schedule();
    }
}

