/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.google.common.collect.Maps;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.PluginsDelegate;
import com.moonlit.logfaces.server.core.LogFacesPlugin;
import com.moonlit.logfaces.server.plugins.PluginHolder;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.IMemento;

public class PluginVO
extends ContextElement
implements Comparable<PluginVO>,
Persistent {
    private String name = "";
    private Map<String, String> lastArgs;
    private LogFacesPlugin plugin;

    public PluginVO(PluginHolder holder) {
        this.plugin = holder.getPlugin();
        this.name = holder.getName();
        this.lastArgs = Maps.newHashMap();
        List args = this.plugin.getArgs();
        if (args != null) {
            for (String arg : this.plugin.getArgs()) {
                this.lastArgs.put(arg, "");
            }
        }
    }

    public PluginVO(IMemento memento) {
        this.load(memento);
        this.plugin = PluginsDelegate.getInstance().getPlugin(this.name);
    }

    @Override
    public void load(IMemento memento) {
        this.name = memento.getString("name");
        this.lastArgs = Maps.newHashMap();
        IMemento[] args = memento.getChildren("arg");
        if (args != null) {
            IMemento[] iMementoArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento arg = iMementoArray[n2];
                this.lastArgs.put(arg.getString("name"), arg.getString("value"));
                ++n2;
            }
        }
    }

    @Override
    public void save(IMemento memento) {
        IMemento root = memento.createChild("plugin");
        root.putString("name", this.name);
        for (String arg : this.lastArgs.keySet()) {
            IMemento m = root.createChild("arg");
            m.putString("name", arg);
            m.putString("value", this.lastArgs.get(arg));
        }
    }

    @Override
    public int compareTo(PluginVO o) {
        return this.name.compareTo(o.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ContextElement getParent() {
        return PluginsDelegate.getInstance();
    }

    @Override
    protected void fireContextChanged() {
    }

    public LogFacesPlugin getPlugin() {
        this.plugin = PluginsDelegate.getInstance().getPlugin(this.name);
        return this.plugin;
    }

    public boolean isUserActionable() {
        return !"IP2Geolocation converter".equals(this.name);
    }
}

