/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.moonlit.logfaces.client.Columns;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.CountersModel;
import com.moonlit.logfaces.client.model.LogHeaderInfoVO;
import com.moonlit.logfaces.client.model.LogPerspectivesModel;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.ui.IMemento;

public class PerspectiveVO
extends ContextElement
implements Cloneable,
Persistent {
    private String name;
    private ContextElement parent;
    private String stackID;
    private CriteriaFilter criteria;
    private boolean scroll;
    private boolean activated;
    private boolean opened;
    private boolean baloon;
    private String fileName;
    private LogHeaderInfoVO[] headers;
    private int size;
    private int nudge;
    private int wakeSound;
    private TimeZone timeZone;
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy");

    public PerspectiveVO() {
        this.headers = Columns.makeDefaultHeaders();
        this.criteria = new JexlCriteria();
        this.timeZone = TimeZone.getDefault();
        this.size = 5000;
    }

    public PerspectiveVO clone() {
        PerspectiveVO ret = new PerspectiveVO();
        ret.name = this.name;
        ret.parent = this.parent;
        ret.stackID = this.stackID;
        ret.activated = this.activated;
        ret.opened = this.opened;
        ret.fileName = this.fileName;
        ret.scroll = this.scroll;
        ret.size = this.size;
        ret.nudge = this.nudge;
        ret.wakeSound = this.wakeSound;
        ret.baloon = this.baloon;
        ret.timeZone = TimeZone.getTimeZone(this.timeZone.getID());
        ret.headers = this.headers;
        ret.criteria = this.criteria.clone();
        return ret;
    }

    public PerspectiveVO(IMemento memento) {
        this.load(memento);
    }

    @Override
    public ContextElement getParent() {
        return this.parent;
    }

    public void setParent(ContextElement parent) {
        this.parent = parent;
    }

    @Override
    protected void fireContextChanged() {
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isScroll() {
        return this.scroll;
    }

    public void setScroll(boolean scroll) {
        this.scroll = scroll;
    }

    public String getStackID() {
        return this.stackID;
    }

    public void setStackID(String stackID) {
        this.stackID = stackID;
    }

    public LogHeaderInfoVO[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(LogHeaderInfoVO[] headers) {
        if (headers != null) {
            this.headers = headers;
        }
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public CriteriaFilter getCriteria() {
        return this.criteria;
    }

    public void setCriteria(CriteriaFilter criteria) {
        this.criteria = criteria;
    }

    public int getNudge() {
        return this.nudge;
    }

    public void setNudge(int nudge) {
        this.nudge = nudge;
    }

    public int getWakeSound() {
        return this.wakeSound;
    }

    public void setWakeSound(int sound) {
        this.wakeSound = sound;
    }

    public boolean isBaloon() {
        return this.baloon;
    }

    public void setBaloon(boolean baloon) {
        this.baloon = baloon;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.timeFormat.setTimeZone(timeZone);
        this.dateFormat.setTimeZone(timeZone);
    }

    public String getDateStamp(long time) {
        return this.dateFormat.format(new Date(time));
    }

    public String getTimeStamp(long time) {
        return this.timeFormat.format(new Date(time));
    }

    public SimpleDateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void load(IMemento memento) {
        this.name = memento.getString("name");
        this.stackID = memento.getString("stackID");
        String p = memento.getString("model");
        if (p != null) {
            if (p.equals(LogPerspectivesModel.class.getName())) {
                this.setParent(LogPerspectivesModel.getInstance());
            } else if (p.equals(CountersModel.class.getName())) {
                this.setParent(CountersModel.getInstance());
            }
        }
        TimeZone tz = TimeZone.getDefault();
        String tzid = memento.getString("timezone");
        if (tzid != null) {
            tz = TimeZone.getTimeZone(tzid);
        }
        this.setTimeZone(tz);
        this.size = memento.getInteger("size");
        this.activated = memento.getInteger("activated") == 1;
        this.opened = memento.getInteger("opened") == 1;
        this.nudge = memento.getInteger("nudge");
        Integer temp = memento.getInteger("baloon");
        this.baloon = temp == null ? false : temp == 1;
        temp = memento.getInteger("wake");
        this.wakeSound = temp != null ? temp : 0;
        this.fileName = memento.getString("fileName");
        this.headers = Utils.unserializeHeaders(memento);
        this.criteria = Utils.unserializeCriteria(memento);
    }

    @Override
    public void save(IMemento parentMem) {
        IMemento memento = parentMem.createChild("logperspective");
        memento.putString("name", this.name);
        memento.putString("model", ((Object)((Object)this.parent)).getClass().getName());
        memento.putString("stackID", this.stackID);
        memento.putString("timezone", this.timeZone.getID());
        memento.putInteger("size", this.size);
        memento.putInteger("activated", this.activated ? 1 : 0);
        memento.putInteger("nudge", this.nudge);
        memento.putInteger("wake", this.wakeSound);
        memento.putInteger("baloon", this.baloon ? 1 : 0);
        memento.putInteger("opened", this.opened ? 1 : 0);
        if (this.fileName != null) {
            memento.putString("fileName", this.fileName);
        }
        Utils.serializeHeaders(this.headers, memento);
        Utils.serializeCriteria(memento, this.criteria);
    }
}

