/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.ParserVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.ui.IMemento;

public class ParsersModel
extends ContextElement
implements Persistent {
    private Map<String, ParserVO> parsers = new TreeMap<String, ParserVO>();
    private static ParsersModel instance;

    public static ParsersModel getInstance() {
        if (instance == null) {
            instance = new ParsersModel();
        }
        return instance;
    }

    private ParsersModel() {
    }

    public List<ParserVO> getParsers() {
        return new ArrayList<ParserVO>(this.parsers.values());
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public ContextElement getParent() {
        return null;
    }

    @Override
    public void fireContextChanged() {
        Application.getPrefs().putLong("lfs_parsers", System.currentTimeMillis());
    }

    public ContextElement[] getEntries() {
        return this.parsers.values().toArray(new ContextElement[this.parsers.size()]);
    }

    public ParserVO create(String name) {
        ParserVO parser = new ParserVO();
        parser.setName(name);
        this.store(parser);
        return parser;
    }

    public void store(ParserVO parser) {
        if (parser != null) {
            this.parsers.put(parser.getName(), parser);
        }
    }

    public ParserVO rename(String name, String newName) {
        ParserVO parser = this.parsers.remove(name);
        if (parser != null) {
            parser.setName(newName);
            this.parsers.put(newName, parser);
            return parser;
        }
        return null;
    }

    public ParserVO get(String name) {
        if (name == null) {
            return null;
        }
        return this.parsers.get(name);
    }

    public ParserVO remove(String name) {
        return this.parsers.remove(name);
    }

    public void clear() {
        this.parsers.clear();
    }

    public int size() {
        return this.parsers.size();
    }

    @Override
    public void load(IMemento memento) {
        this.clear();
        IMemento root = memento.getChild("parsers");
        if (root == null) {
            return;
        }
        IMemento[] iMementoArray = root.getChildren("parser");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento m = iMementoArray[n2];
            this.store(new ParserVO(m));
            ++n2;
        }
    }

    @Override
    public void save(IMemento memento) {
        IMemento root = memento.createChild("parsers");
        for (ParserVO parser : this.parsers.values()) {
            parser.save(root);
        }
    }

    public List<String> getOptions(String what) {
        TreeSet set = Sets.newTreeSet();
        try {
            for (ParserVO parser : this.parsers.values()) {
                if ("pattern".equalsIgnoreCase(what)) {
                    set.add(parser.getPattern());
                    continue;
                }
                if ("patternx".equalsIgnoreCase(what)) {
                    set.add(parser.getPatternEx());
                    continue;
                }
                if (!"dtf".equalsIgnoreCase(what)) continue;
                set.add(parser.getDtf());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Lists.newArrayList((Iterable)set);
    }
}

