/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.moonlit.logfaces.client.Columns;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.LogHeaderInfoVO;
import com.moonlit.logfaces.client.model.ParsersModel;
import com.moonlit.logfaces.client.utils.Utils;
import org.eclipse.ui.IMemento;

public class ParserVO
extends ContextElement
implements Comparable<ParserVO>,
Cloneable,
Persistent {
    private String name = "";
    private String pattern = "";
    private String patternEx = "";
    private String dtf = "";
    private LogHeaderInfoVO[] headers;

    public ParserVO() {
        this.headers = Columns.makeDefaultHeaders();
    }

    public ParserVO(IMemento memento) {
        this.load(memento);
    }

    public ParserVO clone() {
        ParserVO clone = new ParserVO();
        clone.setName(this.name);
        clone.setPattern(this.pattern);
        clone.setPatternEx(this.patternEx);
        clone.setDtf(this.dtf);
        clone.setHeaders(this.headers);
        return clone;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ParserVO)) {
            return false;
        }
        ParserVO other = (ParserVO)o;
        return this.name.equals(other.name) && this.pattern == other.pattern && this.patternEx.equals(other.patternEx) && this.dtf.equals(other.dtf);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int compareTo(ParserVO other) {
        if (other == null) {
            return -1;
        }
        return this.name.compareToIgnoreCase(other.name);
    }

    @Override
    public ContextElement getParent() {
        return ParsersModel.getInstance();
    }

    @Override
    protected void fireContextChanged() {
    }

    @Override
    public void load(IMemento memento) {
        try {
            this.name = memento.getString("name");
            this.pattern = memento.getString("pattern");
            this.patternEx = memento.getString("patternEx");
            this.dtf = memento.getString("dtf");
            this.headers = Utils.unserializeHeaders(memento);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void save(IMemento parent) {
        IMemento memento = parent.createChild("parser");
        memento.putString("name", this.name != null ? this.name : "");
        memento.putString("pattern", this.pattern != null ? this.pattern : "");
        memento.putString("patternEx", this.patternEx != null ? this.patternEx : "");
        memento.putString("dtf", this.dtf != null ? this.dtf : "");
        Utils.serializeHeaders(this.headers, memento);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPatternEx() {
        return this.patternEx;
    }

    public void setPatternEx(String patternEx) {
        this.patternEx = patternEx;
    }

    public String getDtf() {
        return this.dtf;
    }

    public void setDtf(String dtf) {
        this.dtf = dtf;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogHeaderInfoVO[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(LogHeaderInfoVO[] headers) {
        this.headers = headers;
    }
}

