/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.ContextListener;
import com.moonlit.logfaces.client.model.PerspectiveVO;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ui.IMemento;

public class LogPerspectivesModel
extends ContextElement
implements Persistent {
    private TreeMap<String, PerspectiveVO> perpectives = new TreeMap();
    private ListenerList<ContextListener> listeners = new ListenerList();
    private static LogPerspectivesModel instance;

    private LogPerspectivesModel() {
    }

    public static LogPerspectivesModel getInstance() {
        if (instance == null) {
            instance = new LogPerspectivesModel();
        }
        return instance;
    }

    @Override
    public String getName() {
        return "root";
    }

    @Override
    public ContextElement getParent() {
        return null;
    }

    public ContextElement[] getEntries() {
        if (this.perpectives != null) {
            return this.perpectives.values().toArray(new ContextElement[this.perpectives.size()]);
        }
        return new ContextElement[0];
    }

    public List<PerspectiveVO> listEntries() {
        return Lists.newArrayList(this.perpectives.values());
    }

    public void addPerspective(PerspectiveVO entry) {
        entry.setParent(this);
        this.perpectives.put(entry.getName(), entry);
        this.fireContextChanged();
    }

    public PerspectiveVO getPerspective(String name) {
        return this.perpectives.get(name);
    }

    public void removePerspective(String name) {
        this.perpectives.remove(name);
        this.fireContextChanged();
    }

    public void removeAll() {
        this.perpectives.clear();
        this.fireContextChanged();
    }

    public boolean hasPerspective(String name) {
        return this.perpectives.get(name) != null;
    }

    public void addContextListener(ContextListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeContextListener(ContextListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    protected void fireContextChanged() {
        Object[] rls = this.listeners.getListeners();
        int i = 0;
        while (i < rls.length) {
            ContextListener listener = (ContextListener)rls[i];
            listener.contextChanged();
            ++i;
        }
    }

    @Override
    public void load(IMemento memento) {
        this.removeAll();
        IMemento root = memento.getChild("logperspectives");
        if (root == null) {
            return;
        }
        IMemento[] iMementoArray = root.getChildren("logperspective");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento m = iMementoArray[n2];
            this.addPerspective(new PerspectiveVO(m));
            ++n2;
        }
    }

    @Override
    public void save(IMemento memento) {
        IMemento root = memento.createChild("logperspectives");
        for (PerspectiveVO p : this.perpectives.values()) {
            p.save(root);
        }
    }
}

