/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import java.util.TimeZone;
import org.eclipse.ui.IMemento;

public class FastFetch
implements Persistent {
    private static FastFetch instance;
    private QueryVO query = new QueryVO("Fast fetch");

    private FastFetch() {
        this.query.setTimeRange(TimeRange.BEFORE_1_HOUR, 0L, 0L);
        this.query.setTimeZone(TimeZone.getDefault());
        this.setDefaultCriteria();
    }

    public static FastFetch getInstance() {
        if (instance == null) {
            instance = new FastFetch();
        }
        return instance;
    }

    private void setDefaultCriteria() {
        JexlCriteria criteria = new JexlCriteria();
        criteria.addRule().addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)LfsLevel.INFO.name());
        this.query.setCriteria((CriteriaFilter)criteria);
    }

    public QueryVO getQuery() {
        return this.query;
    }

    public void setQuery(QueryVO query) {
        this.query = query;
    }

    @Override
    public void load(IMemento memento) {
        IMemento root = memento.getChild("fastfetch");
        if (root == null) {
            return;
        }
        IMemento m = memento.getChild("query");
        if (m == null) {
            return;
        }
        this.query = new QueryVO(m);
        if (this.query.getCriteria() == null) {
            this.setDefaultCriteria();
        }
    }

    @Override
    public void save(IMemento memento) {
        IMemento root = memento.createChild("fastfetch");
        if (this.query != null) {
            this.query.save(root);
        }
    }
}

