/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.model.EventStyle;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class EventStyles {
    private static EventStyles instance;
    private Map<Integer, EventStyle> styles = new TreeMap<Integer, EventStyle>();
    private EventStyle defaultStyle;
    public static final Color BG_SELECTION;
    public static final Color BG_LFS;
    public static final Color BG_LFS2;
    public static final Color FG_LFS;
    public static final Color BG_WARN;
    public static final Color BG_FATAL;
    public static final Color BG_ERROR;
    public static final Color BG_DEBUG;
    public static final Color BG_TRACE;
    public static final Color BG_INFO;
    public static final Color BG_TRACE_D;
    public static final Color BG_DEBUG_D;
    public static final Color BG_INFO_D;
    public static final Color BG_WARN_D;
    public static final Color BG_ERROR_D;
    public static final Color BG_FATAL_D;
    public static final Color BG_DRILL;
    public static final Color FG_DRILL;
    public static final Color FG_DEBUG;
    public static final Color FG_DEFAULT;
    public static final Color BG_BOOKMARK;
    public static final Color FG_BOOKMARK;
    public static final Color RULER_WARN;
    public static final Color RULER_FATAL;
    public static final Color RULER_ERROR;
    public static final Color RULER_EXCEPT;

    static {
        BG_SELECTION = new Color(null, 182, 203, 203);
        BG_LFS = new Color(null, 241, 245, 245);
        BG_LFS2 = new Color(null, 244, 247, 247);
        FG_LFS = new Color(null, 113, 112, 116);
        BG_WARN = new Color(null, 255, 255, 220);
        BG_FATAL = new Color(null, 240, 240, 240);
        BG_ERROR = new Color(null, 255, 234, 240);
        BG_DEBUG = new Color(null, 240, 255, 240);
        BG_TRACE = new Color(null, 230, 240, 255);
        BG_INFO = new Color(null, 255, 255, 255);
        BG_TRACE_D = new Color(null, 139, 182, 216);
        BG_DEBUG_D = new Color(null, 204, 227, 195);
        BG_INFO_D = new Color(null, 255, 255, 255);
        BG_WARN_D = new Color(null, 250, 246, 179);
        BG_ERROR_D = new Color(null, 250, 184, 193);
        BG_FATAL_D = new Color(null, 204, 204, 204);
        BG_DRILL = new Color(null, 0, 80, 160);
        FG_DRILL = new Color(null, 255, 255, 50);
        FG_DEBUG = new Color(null, 128, 128, 128);
        FG_DEFAULT = new Color(null, 0, 0, 0);
        BG_BOOKMARK = new Color(null, 204, 235, 195);
        FG_BOOKMARK = new Color(null, 0, 0, 0);
        RULER_WARN = new Color(null, 255, 255, 0);
        RULER_FATAL = new Color(null, 0, 0, 0);
        RULER_ERROR = new Color(null, 255, 0, 0);
        RULER_EXCEPT = new Color(null, 0, 80, 160);
    }

    public static EventStyles getInstance() {
        if (instance == null) {
            instance = new EventStyles();
        }
        return instance;
    }

    private EventStyles() {
        for (LfsLevel level : LfsLevel.toList()) {
            EventStyle style = new EventStyle();
            style.setBackground(this.getColor(level.intLevel(), false));
            style.setForeground(this.getColor(level.intLevel(), true));
            style.setImage(this.getImage(level.intLevel()));
            style.setImageDescriptor(this.getImageDescriptor(level.intLevel()));
            style.setImageResource(this.getImageResource(level.intLevel()));
            this.styles.put(level.intLevel(), style);
        }
        this.defaultStyle = new EventStyle();
        this.defaultStyle.setBackground(BG_INFO);
        this.defaultStyle.setForeground(FG_DEFAULT);
    }

    protected Color getColor(int level, boolean fg) {
        try {
            String key = fg ? "level-fg-" + level : "level-bg-" + level;
            String rgb = Application.getPrefs().get(key, null);
            if (rgb == null) {
                return fg ? this.getDefaultForeground(level) : this.getDefaultBackground(level);
            }
            String[] split = StringUtils.tokenizeToStringArray(rgb, ",");
            return new Color(null, Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
        }
        catch (NumberFormatException e) {
            return fg ? this.getDefaultForeground(level) : this.getDefaultBackground(level);
        }
    }

    protected void persistColor(int level, boolean fg) {
        EventStyle style = this.styles.get(level);
        String key = fg ? "level-fg-" + level : "level-bg-" + level;
        Color color = fg ? style.getForeground() : style.getBackground();
        Application.getPrefs().put(key, color.getRed() + "," + color.getGreen() + "," + color.getBlue());
    }

    public Color getDefaultBackground(int level) {
        if (level <= LfsLevel.TRACE.intLevel()) {
            return BG_TRACE;
        }
        if (level <= LfsLevel.DEBUG.intLevel()) {
            return BG_DEBUG;
        }
        if (level <= LfsLevel.INFO.intLevel()) {
            return BG_INFO;
        }
        if (level <= LfsLevel.WARN.intLevel()) {
            return BG_WARN;
        }
        if (level <= LfsLevel.ERROR.intLevel()) {
            return BG_ERROR;
        }
        if (level <= LfsLevel.FATAL.intLevel()) {
            return BG_FATAL;
        }
        return BG_INFO;
    }

    public Color getDefaultForeground(int level) {
        if (level <= LfsLevel.DEBUG.intLevel()) {
            return FG_DEBUG;
        }
        return FG_DEFAULT;
    }

    public Color getDarkerBackground(int level) {
        switch (level) {
            case 5000: {
                return BG_TRACE_D;
            }
            case 10000: {
                return BG_DEBUG_D;
            }
            case 20000: {
                return BG_INFO_D;
            }
            case 30000: {
                return BG_WARN_D;
            }
            case 40000: {
                return BG_ERROR_D;
            }
            case 50000: {
                return BG_FATAL_D;
            }
        }
        return this.getColor(level, false);
    }

    protected String getImageResource(int level) {
        String resource = Application.getPrefs().get("level-img-" + level, null);
        if (resource != null) {
            return resource;
        }
        return this.getDefaultImageResource(level);
    }

    protected ImageDescriptor getImageDescriptor(int level) {
        String resource = Application.getPrefs().get("level-img-" + level, null);
        if (resource == null) {
            return this.getDefaultImageDescriptor(level);
        }
        return MainPlugin.getImageDescriptor(resource);
    }

    public ImageDescriptor getDefaultImageDescriptor(int level) {
        switch (level) {
            case 5000: {
                return MainPlugin.getImageDescriptor("icons/trace.gif");
            }
            case 10000: {
                return MainPlugin.getImageDescriptor("icons/level_debug3.gif");
            }
            case 20000: {
                return MainPlugin.getImageDescriptor("icons/message_info.gif");
            }
            case 30000: {
                return MainPlugin.getImageDescriptor("icons/task_warning_misc.gif");
            }
            case 40000: {
                return MainPlugin.getImageDescriptor("icons/message_error.gif");
            }
            case 50000: {
                return MainPlugin.getImageDescriptor("icons/level_fatal2.gif");
            }
        }
        return MainPlugin.getImageDescriptor("icons/eclipse3_help.gif");
    }

    public String getDefaultImageResource(int level) {
        switch (level) {
            case 5000: {
                return "icons/trace.gif";
            }
            case 10000: {
                return "icons/level_debug3.gif";
            }
            case 20000: {
                return "icons/message_info.gif";
            }
            case 30000: {
                return "icons/task_warning_misc.gif";
            }
            case 40000: {
                return "icons/message_error.gif";
            }
            case 50000: {
                return "icons/level_fatal2.gif";
            }
        }
        return "icons/eclipse3_help.gif";
    }

    protected Image getImage(int level) {
        String imageResource = Application.getPrefs().get("level-img-" + level, null);
        if (imageResource == null) {
            return this.getDefaultImage(level);
        }
        return this.getImageDescriptor(level).createImage();
    }

    public Image getDefaultImage(int level) {
        EventStyle style = this.styles.get(level);
        if (style != null) {
            return style.getImage();
        }
        ImageDescriptor id = this.getDefaultImageDescriptor(level);
        if (id == null) {
            return null;
        }
        return id.createImage();
    }

    protected void persistImage(int level) {
        EventStyle style = this.styles.get(level);
        if (style != null) {
            Application.getPrefs().put("level-img-" + level, style.getImageResource());
        }
    }

    public Map<Integer, EventStyle> getStyles() {
        TreeMap<Integer, EventStyle> ret = new TreeMap<Integer, EventStyle>();
        for (Integer key : this.styles.keySet()) {
            ret.put(key, this.styles.get(key).clone());
        }
        return ret;
    }

    public Map<Integer, EventStyle> getDefaultStyles() {
        TreeMap<Integer, EventStyle> ret = new TreeMap<Integer, EventStyle>();
        for (LfsLevel level : LfsLevel.toList()) {
            EventStyle style = new EventStyle();
            style.setBackground(this.getDefaultBackground(level.intLevel()));
            style.setForeground(this.getDefaultForeground(level.intLevel()));
            style.setImage(this.getDefaultImage(level.intLevel()));
            style.setImageDescriptor(this.getDefaultImageDescriptor(level.intLevel()));
            style.setImageResource(this.getDefaultImageResource(level.intLevel()));
            ret.put(level.intLevel(), style);
        }
        return ret;
    }

    public EventStyle getBookmarkStyle(LogEvent event) {
        EventStyle style = new EventStyle();
        style.setBackground(BG_BOOKMARK);
        style.setForeground(FG_BOOKMARK);
        style.setBold(true);
        if (event instanceof LoggingEventVO) {
            int level = ((LoggingEventVO)event).getLoggerLevel();
            style.setImage(this.getDefaultImage(level));
            style.setImageDescriptor(this.getDefaultImageDescriptor(level));
            style.setImageResource(this.getDefaultImageResource(level));
        }
        return style;
    }

    public EventStyle getStyle(LogEvent event) {
        EventStyle ret = this.styles.get(event.getLoggerLevel());
        return ret == null ? this.defaultStyle : ret;
    }

    public EventStyle getStyle(int level) {
        EventStyle ret = this.styles.get(level);
        return ret == null ? this.defaultStyle : ret;
    }

    public boolean setStyles(Map<Integer, EventStyle> newStyles) {
        boolean dirty = false;
        for (Integer key : newStyles.keySet()) {
            if (newStyles.get(key).equals(this.styles.get(key))) continue;
            dirty = true;
            break;
        }
        this.styles.clear();
        for (Integer key : newStyles.keySet()) {
            this.styles.put(key, newStyles.get(key).clone());
        }
        this.persist();
        return dirty;
    }

    public void persist() {
        for (LfsLevel level : LfsLevel.toList()) {
            this.persistColor(level.intLevel(), true);
            this.persistColor(level.intLevel(), false);
            this.persistImage(level.intLevel());
        }
    }
}

