/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.CounterModel;
import com.moonlit.logfaces.client.model.CounterModelListener;
import com.moonlit.logfaces.client.model.PerspectiveVO;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.vo.CounterVO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.IMemento;

public class CountersModel
extends ContextElement
implements Persistent {
    private List<CounterModel> counters = new ArrayList<CounterModel>();
    private static CountersModel instance;
    private List<CounterModelListener> listeners = new ArrayList<CounterModelListener>();

    private CountersModel() {
    }

    public static synchronized CountersModel getInstance() {
        if (instance == null) {
            instance = new CountersModel();
        }
        return instance;
    }

    @Override
    protected void fireContextChanged() {
        for (CounterModelListener listener : this.listeners) {
            listener.contextChanged();
        }
    }

    protected void fireDashboardUpdated() {
        for (CounterModelListener listener : this.listeners) {
            listener.dashboardUpdated();
        }
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public ContextElement getParent() {
        return null;
    }

    public void addListener(CounterModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CounterModelListener listener) {
        this.listeners.remove(listener);
    }

    public ContextElement[] getEntries() {
        if (this.counters != null) {
            return this.counters.toArray(new ContextElement[this.counters.size()]);
        }
        return new ContextElement[0];
    }

    public List<CounterModel> getCounters() {
        return this.counters;
    }

    public Map<Integer, CriteriaFilter> getSettings() {
        HashMap<Integer, CriteriaFilter> ret = new HashMap<Integer, CriteriaFilter>();
        for (CounterModel counter : this.counters) {
            ret.put(counter.getCounter().getId(), counter.getSettings().getCriteria());
        }
        return ret;
    }

    public synchronized CounterModel getFirst() {
        if (this.counters != null && this.counters.size() > 0) {
            return this.counters.get(0);
        }
        return null;
    }

    public CounterModel getCounterByIndex(int index) {
        if (index >= 0 && index < this.counters.size()) {
            return this.counters.get(index);
        }
        return null;
    }

    public CounterModel getCounter(int counterID) {
        for (CounterModel model : this.counters) {
            if (model.getCounter().getId() != counterID) continue;
            return model;
        }
        return null;
    }

    public synchronized CounterModel add(PerspectiveVO perspective) {
        CounterModel model = new CounterModel(perspective);
        this.counters.add(model);
        this.fireContextChanged();
        return model;
    }

    public synchronized void addAll(List<PerspectiveVO> list) {
        for (PerspectiveVO perspective : list) {
            this.counters.add(new CounterModel(perspective));
        }
        this.fireContextChanged();
    }

    public synchronized void remove(CounterModel counter) {
        this.counters.remove((Object)counter);
        this.fireContextChanged();
    }

    public synchronized void removeAll() {
        this.counters.clear();
        this.fireContextChanged();
    }

    public synchronized void moveUp(int index) {
        if (index > 0) {
            Collections.swap(this.counters, index, index - 1);
            this.fireContextChanged();
        }
    }

    public synchronized void moveDown(int index) {
        if (index < this.counters.size()) {
            Collections.swap(this.counters, index, index + 1);
            this.fireContextChanged();
        }
    }

    public List<String> getCounterNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (CounterModel model : this.counters) {
            ret.add(model.getName());
        }
        return ret;
    }

    public synchronized List<Integer> getValues() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (CounterModel model : this.counters) {
            ret.add(model.getCounter().getValue());
        }
        return ret;
    }

    public synchronized void setValues(Map<Integer, Integer> values) {
        for (CounterModel model : this.counters) {
            CounterVO counter = model.getCounter();
            Integer value = values.get(counter.getId());
            if (value == null) continue;
            counter.setValue(value.intValue());
        }
        this.fireDashboardUpdated();
    }

    @Override
    public void load(IMemento memento) {
        this.removeAll();
        IMemento root = memento.getChild("dashboard");
        if (root == null) {
            return;
        }
        IMemento[] iMementoArray = memento.getChildren("logperspective");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento m = iMementoArray[n2];
            PerspectiveVO perspective = new PerspectiveVO(m);
            this.counters.add(new CounterModel(perspective));
            ++n2;
        }
    }

    @Override
    public void save(IMemento memento) {
        IMemento root = memento.createChild("dashboard");
        for (CounterModel model : this.counters) {
            model.getSettings().save(root);
        }
    }
}

