/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.ComponentModel;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.ContextListener;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ui.IMemento;

public class ComponentsModel
extends ContextElement
implements Persistent {
    private Map<String, ComponentModel> components = new TreeMap<String, ComponentModel>();
    private Map<String, String> hash = new HashMap<String, String>();
    private static ComponentsModel instance;
    private ListenerList<ContextListener> listeners = new ListenerList();

    private ComponentsModel() {
    }

    public static ComponentsModel getInstance() {
        if (instance == null) {
            instance = new ComponentsModel();
        }
        return instance;
    }

    @Override
    public void load(IMemento memento) {
        this.clear();
        IMemento root = memento.getChild("components");
        if (root == null) {
            return;
        }
        IMemento[] iMementoArray = root.getChildren("component");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento cm = iMementoArray[n2];
            ComponentModel component = new ComponentModel(cm);
            this.components.put(component.getName(), component);
            String[] stringArray = component.getPackageNames();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String pack = stringArray[n4];
                this.hash.put(pack, component.getName());
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public void save(IMemento memento) {
        IMemento root = memento.createChild("components");
        for (ComponentModel component : this.components.values()) {
            component.save(root);
        }
    }

    @Override
    protected void fireContextChanged() {
        Object[] rls = this.listeners.getListeners();
        int i = 0;
        while (i < rls.length) {
            ContextListener listener = (ContextListener)rls[i];
            listener.contextChanged();
            ++i;
        }
    }

    @Override
    public String getName() {
        return "components";
    }

    @Override
    public ContextElement getParent() {
        return null;
    }

    public ComponentModel getComponent(String name) {
        return this.components.get(name);
    }

    public Collection<String> getPackageNames(String component) {
        TreeSet packs = Sets.newTreeSet();
        ComponentModel cmodel = this.getComponent(component);
        String[] stringArray = cmodel.getPackageNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            packs.add(name);
            ++n2;
        }
        return packs;
    }

    public String[] getFullLoggerNames(String[] components) {
        TreeSet<String> ret = new TreeSet<String>();
        String[] stringArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            String compName = stringArray[n2];
            ComponentModel cmodel = this.getComponent(compName);
            if (cmodel != null) {
                String[] stringArray2 = cmodel.getFullLoggerNames();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String name = stringArray2[n4];
                    ret.add(name);
                    ++n4;
                }
            }
            ++n2;
        }
        return ret.toArray(new String[ret.size()]);
    }

    public Collection<String> getComponentNames() {
        return this.components.keySet();
    }

    public void addContextListener(ContextListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeContextListener(ContextListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void addComponent(String name, Collection<String> packages) {
        ComponentModel component = new ComponentModel(name);
        component.setPackages(packages, true);
        this.components.put(name, component);
        for (String pack : packages) {
            this.hash.put(pack, name);
        }
        this.fireContextChanged();
    }

    public ComponentModel addComponent(String name, String[] names) {
        ComponentModel component = new ComponentModel(name);
        component.setPackages(names);
        this.components.put(name, component);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String pack = stringArray[n2];
            this.hash.put(pack, name);
            ++n2;
        }
        this.fireContextChanged();
        return component;
    }

    public void rehash(ComponentModel component) {
        String[] stringArray = component.getPackageNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pack = stringArray[n2];
            this.hash.put(pack, component.getName());
            ++n2;
        }
    }

    public void removeComponent(String name) {
        this.components.remove(name);
        while (this.hash.values().contains(name)) {
            this.hash.values().remove(name);
        }
        this.fireContextChanged();
    }

    public void renameComponent(String name, String newName) {
        ComponentModel component = this.components.remove(name);
        if (component == null) {
            return;
        }
        component.setName(newName);
        this.components.put(newName, component);
        for (String pack : this.hash.keySet()) {
            if (!this.hash.get(pack).equals(name)) continue;
            this.hash.put(pack, newName);
        }
        this.fireContextChanged();
    }

    public ComponentModel[] getComponents() {
        return this.components.values().toArray(new ComponentModel[this.components.size()]);
    }

    public Map<String, List<String>> toMap() {
        HashMap map = Maps.newHashMap();
        for (String name : this.components.keySet()) {
            ComponentModel component = this.components.get(name);
            map.put(name, component.getPackageNamesList());
        }
        return map;
    }

    public String getComponent(LoggingEventVO event) {
        String packageName = event.getLoggerNamePackage();
        if (packageName == null) {
            return "";
        }
        return this.hash.containsKey(packageName) ? this.hash.get(packageName) : "";
    }

    public ComponentModel getComponentModel(LoggingEventVO event) {
        String packageName = event.getLoggerNamePackage();
        if (packageName != null) {
            for (ComponentModel component : this.components.values()) {
                if (!component.getPackageNamesList().contains(packageName)) continue;
                return component;
            }
        }
        return null;
    }

    public String[] getPackageNames(LoggingEventVO event) {
        String componentName = this.getComponent(event);
        ComponentModel model = this.components.get(componentName);
        if (model != null) {
            return model.getPackageNames();
        }
        return new String[0];
    }

    public void clear() {
        this.components.clear();
        this.hash.clear();
        this.fireContextChanged();
    }
}

