/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.ComponentPackageModel;
import com.moonlit.logfaces.client.model.ComponentsModel;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.model.RepositoryModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.ui.IMemento;

public class ComponentModel
extends ContextElement
implements Persistent {
    private String name;
    private ContextElement parent;
    private List<ComponentPackageModel> packages;

    public ComponentModel(String name) {
        this.name = name;
        this.parent = ComponentsModel.getInstance();
        this.packages = new ArrayList<ComponentPackageModel>();
    }

    public ComponentModel(IMemento memento) {
        this.parent = ComponentsModel.getInstance();
        this.packages = new ArrayList<ComponentPackageModel>();
        this.load(memento);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ContextElement getParent() {
        return this.parent;
    }

    @Override
    protected void fireContextChanged() {
        this.parent.fireContextChanged();
    }

    public ComponentPackageModel[] getPackages() {
        return this.packages.toArray(new ComponentPackageModel[this.packages.size()]);
    }

    public String[] getPackageNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (ComponentPackageModel model : this.packages) {
            ret.add(model.getName());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public List<String> getPackageNamesList() {
        ArrayList<String> ret = new ArrayList<String>();
        for (ComponentPackageModel model : this.packages) {
            ret.add(model.getName());
        }
        return ret;
    }

    public String[] getFullLoggerNames() {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> packs = this.getPackageNamesList();
        for (String logger : RepositoryModel.getInstance().getLoggerNames()) {
            int index = logger.lastIndexOf(46);
            String lpn = logger;
            if (index != -1) {
                lpn = logger.substring(0, index);
            }
            if (!packs.contains(lpn)) continue;
            ret.add(logger);
        }
        return ret.toArray(new String[ret.size()]);
    }

    public void setPackages(String[] names) {
        this.packages.clear();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.packages.add(new ComponentPackageModel(name, this));
            ++n2;
        }
        this.fireContextChanged();
    }

    public void setPackages(Collection<String> names, boolean append) {
        if (!append) {
            this.packages.clear();
        }
        for (String name : names) {
            this.packages.add(new ComponentPackageModel(name, this));
        }
        this.fireContextChanged();
    }

    public void removePackage(ComponentPackageModel pm) {
        this.packages.remove((Object)pm);
        this.fireContextChanged();
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void load(IMemento memento) {
        this.name = memento.getString("name");
        IMemento[] iMementoArray = memento.getChildren("package");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento pmm = iMementoArray[n2];
            this.packages.add(new ComponentPackageModel(pmm.getString("name"), this));
            ++n2;
        }
    }

    @Override
    public void save(IMemento memento) {
        String[] packages;
        IMemento cm = memento.createChild("component");
        cm.putString("name", this.getName());
        String[] stringArray = packages = this.getPackageNames();
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String pack = stringArray[n2];
            IMemento pm = cm.createChild("package");
            pm.putString("name", pack);
            ++n2;
        }
    }
}

