/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.utils.Utils;
import java.util.BitSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.ui.IMemento;

public class ColumnSetVO
implements Persistent {
    private String name = "";
    private long mask;
    private static Logger log = LogManager.getLogger(ColumnSetVO.class);

    public ColumnSetVO(String name, long mask) {
        this.name = name;
        this.mask = mask;
    }

    public ColumnSetVO(IMemento memento) {
        this.load(memento);
    }

    @Override
    public void load(IMemento memento) {
        try {
            this.name = memento.getString("name");
            this.mask = Long.parseLong(memento.getString("mask"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void save(IMemento memento) {
        try {
            IMemento root = memento.createChild("set");
            root.putString("name", this.name);
            root.putString("mask", "" + this.mask);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BitSet getMask() {
        return Utils.mask(this.mask);
    }

    public void setMask(BitSet mask) {
        this.mask = Utils.unmask(mask);
    }
}

