/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.ColumnSetVO;
import com.moonlit.logfaces.client.utils.Utils;
import java.util.BitSet;
import java.util.List;
import org.eclipse.ui.IMemento;

public class ColumnSetModel
implements Persistent {
    private static ColumnSetModel instance;
    private List<ColumnSetVO> model = Lists.newArrayList();

    private ColumnSetModel() {
    }

    public static ColumnSetModel getInstance() {
        if (instance == null) {
            instance = new ColumnSetModel();
        }
        return instance;
    }

    @Override
    public void load(IMemento memento) {
        this.model.clear();
        IMemento root = memento.getChild("columns");
        if (root == null) {
            this.convert();
            return;
        }
        IMemento[] iMementoArray = root.getChildren("set");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento m = iMementoArray[n2];
            this.model.add(new ColumnSetVO(m));
            ++n2;
        }
        if (this.model.isEmpty()) {
            this.convert();
        }
    }

    @Override
    public void save(IMemento memento) {
        IMemento root = memento.createChild("columns");
        for (ColumnSetVO vo : this.model) {
            vo.save(root);
        }
    }

    public ColumnSetVO getColumnSet(int index) {
        return this.model.get(index);
    }

    private void convert() {
        BitSet mask = new BitSet();
        mask.set(0);
        mask.set(3);
        mask.set(12);
        this.model.add(new ColumnSetVO("Brief", Utils.unmask(mask)));
        mask.clear();
        mask.set(0);
        mask.set(3);
        mask.set(4);
        mask.set(10);
        mask.set(12);
        this.model.add(new ColumnSetVO("Compact", Utils.unmask(mask)));
        mask.clear();
        mask.set(0);
        mask.set(1);
        mask.set(3);
        mask.set(4);
        mask.set(5);
        mask.set(10);
        mask.set(7);
        mask.set(12);
        this.model.add(new ColumnSetVO("Normal", Utils.unmask(mask)));
        mask.set(0, 64);
        this.model.add(new ColumnSetVO("Verbose", Utils.unmask(mask)));
    }
}

