/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.model;

import com.moonlit.logfaces.client.model.ChoiceModelItem;
import com.moonlit.logfaces.client.model.ChoiceModelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.PlatformObject;

public class ChoiceModel
extends PlatformObject {
    private TreeMap<String, ChoiceModelItem> items = new TreeMap();
    private List<ChoiceModelListener> listeners = new ArrayList<ChoiceModelListener>();
    private String filter;
    private boolean singleSelection;

    public ChoiceModel() {
    }

    public ChoiceModel(Object[] data) {
        int i = 0;
        while (i < data.length) {
            ChoiceModelItem item = new ChoiceModelItem(this, data[i], false);
            this.items.put(item.toString(), item);
            ++i;
        }
    }

    public ChoiceModel(Collection data) {
        Iterator it = data.iterator();
        while (it.hasNext()) {
            ChoiceModelItem item = new ChoiceModelItem(this, it.next(), false);
            this.items.put(item.toString(), item);
        }
    }

    public void addListener(ChoiceModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ChoiceModelListener listener) {
        this.listeners.add(listener);
    }

    public void addItem(Object item, boolean selected) {
        ChoiceModelItem theItem = new ChoiceModelItem(this, item, selected);
        this.items.put(theItem.toString(), theItem);
        for (ChoiceModelListener listener : this.listeners) {
            listener.itemAdded(theItem);
        }
    }

    public void removeItem(ChoiceModelItem item) {
        this.items.remove(item.toString());
        for (ChoiceModelListener listener : this.listeners) {
            listener.itemRemoved(item);
        }
    }

    public void clear() {
        this.items.clear();
        for (ChoiceModelListener listener : this.listeners) {
            listener.cleared();
        }
    }

    public void updateItem(ChoiceModelItem item) {
        this.items.put(item.toString(), item);
        for (ChoiceModelListener listener : this.listeners) {
            listener.itemUpdated(item);
        }
    }

    public ChoiceModelItem[] getItems() {
        if (this.filter == null) {
            return this.items.values().toArray(new ChoiceModelItem[this.items.size()]);
        }
        if (this.filter.length() == 0) {
            return this.items.values().toArray(new ChoiceModelItem[this.items.size()]);
        }
        ArrayList<ChoiceModelItem> ret = new ArrayList<ChoiceModelItem>();
        for (String name : this.items.keySet()) {
            if (name.indexOf(this.filter) == -1) continue;
            ret.add(this.items.get(name));
        }
        return ret.toArray(new ChoiceModelItem[ret.size()]);
    }

    public ChoiceModelItem[] getSelection() {
        Vector<ChoiceModelItem> ret = new Vector<ChoiceModelItem>();
        for (ChoiceModelItem item : this.items.values()) {
            if (!item.isSelected()) continue;
            ret.add(item);
        }
        return ret.toArray(new ChoiceModelItem[ret.size()]);
    }

    public String[] getSelectionAsString() {
        Vector<String> ret = new Vector<String>();
        for (ChoiceModelItem item : this.items.values()) {
            if (!item.isSelected()) continue;
            ret.add(item.getItem().toString());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public Set getSelectionAsSet() {
        HashSet<String> ret = new HashSet<String>();
        for (ChoiceModelItem item : this.items.values()) {
            if (!item.isSelected()) continue;
            ret.add(item.getItem().toString());
        }
        return ret;
    }

    public String getSelectionAsRegex() {
        Object ret = "";
        for (ChoiceModelItem item : this.items.values()) {
            if (!item.isSelected()) continue;
            if (((String)ret).length() > 0) {
                ret = (String)ret + "|";
            }
            ret = (String)ret + Pattern.quote(item.getItem().toString());
        }
        return ret;
    }

    public void selectItem(String name, boolean select) {
        ChoiceModelItem item;
        if (select && this.singleSelection) {
            this.selectAll(false);
        }
        if ((item = this.items.get(name)) != null) {
            item.setSelected(select);
        }
    }

    public boolean isItemSelected(String name) {
        ChoiceModelItem item = this.items.get(name);
        if (item != null) {
            return item.isSelected();
        }
        return false;
    }

    public void selectItems(Object[] data) {
        if (data == null || this.singleSelection) {
            this.selectAll(false);
            return;
        }
        int i = 0;
        while (i < data.length) {
            ChoiceModelItem item = this.items.get(data[i]);
            if (item != null) {
                item.setSelected(true);
            }
            ++i;
        }
    }

    public void deselectItems(Object[] data) {
        if (data == null || this.singleSelection) {
            return;
        }
        int i = 0;
        while (i < data.length) {
            ChoiceModelItem item = this.items.get(data[i]);
            if (item != null) {
                item.setSelected(false);
            }
            ++i;
        }
    }

    public void selectAll(boolean select) {
        if (select && this.singleSelection) {
            return;
        }
        for (ChoiceModelItem item : this.items.values()) {
            item.setSelected(select);
        }
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean isSingleSelection() {
        return this.singleSelection;
    }

    public void setSingleSelection(boolean singleSelection) {
        this.singleSelection = singleSelection;
    }
}

